/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.api.models.base;

import com.plivo.api.PlivoClient;
import com.plivo.api.exceptions.PlivoRestException;
import com.plivo.api.exceptions.PlivoValidationException;
import com.plivo.api.models.base.BaseRequest;
import com.plivo.api.models.base.BaseResource;
import java.io.IOException;
import retrofit2.Call;
import retrofit2.Response;

public abstract class MessagingDeleter<T extends BaseResource>
extends BaseRequest {
    protected String id;
    protected String secondaryId;

    public MessagingDeleter(String id) {
        this.id = id;
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
    }

    public MessagingDeleter(String id, String secondaryId) {
        if (id == null || secondaryId == null) {
            throw new IllegalArgumentException("id/secondaryId cannot be null");
        }
        this.id = id;
        this.secondaryId = secondaryId;
    }

    public T delete() throws IOException, PlivoRestException, PlivoValidationException {
        this.validate();
        Response response = this.obtainCall().execute();
        this.handleResponse(response);
        return (T)((BaseResource)response.body());
    }

    @Override
    public MessagingDeleter<T> client(PlivoClient plivoClient) {
        this.plivoClient = plivoClient;
        return this;
    }

    protected abstract Call<T> obtainCall() throws PlivoValidationException;
}

