/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.api.models.application;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.plivo.api.models.application.ApplicationCreator;
import com.plivo.api.models.application.ApplicationDeleter;
import com.plivo.api.models.application.ApplicationGetter;
import com.plivo.api.models.application.ApplicationLister;
import com.plivo.api.models.application.ApplicationUpdater;
import com.plivo.api.models.base.BaseResource;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Application
extends BaseResource {
    private String answerUrl;
    private String answerMethod;
    private String appId;
    private String appName;
    private Boolean defaultApp;
    private Boolean defaultEndpointApp;
    private Boolean enabled;
    private String fallbackAnswerUrl;
    private String fallbackMethod;
    private String hangupUrl;
    private String hangupMethod;
    private String messageMethod;
    private String messageUrl;
    private Boolean publicUri;
    private String resourceUri;
    private String sipUri;
    private String subAccount;

    public static ApplicationCreator creator(String appName) {
        return new ApplicationCreator(appName);
    }

    public static ApplicationUpdater updater(String id) {
        return new ApplicationUpdater(id);
    }

    public static ApplicationGetter getter(String id) {
        return new ApplicationGetter(id);
    }

    public static ApplicationDeleter deleter(String id) {
        return new ApplicationDeleter(id);
    }

    public static ApplicationLister lister() {
        return new ApplicationLister();
    }

    public Boolean getDefaultEndpointApp() {
        return this.defaultEndpointApp;
    }

    public String getAnswerUrl() {
        return this.answerUrl;
    }

    public String getAnswerMethod() {
        return this.answerMethod;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getAppName() {
        return this.appName;
    }

    public Boolean getDefaultApp() {
        return this.defaultApp;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public String getFallbackAnswerUrl() {
        return this.fallbackAnswerUrl;
    }

    public String getFallbackMethod() {
        return this.fallbackMethod;
    }

    public String getHangupUrl() {
        return this.hangupUrl;
    }

    public String getHangupMethod() {
        return this.hangupMethod;
    }

    public String getMessageMethod() {
        return this.messageMethod;
    }

    public String getMessageUrl() {
        return this.messageUrl;
    }

    public Boolean getPublicUri() {
        return this.publicUri;
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public String getSipUri() {
        return this.sipUri;
    }

    public String getSubAccount() {
        return this.subAccount;
    }

    public ApplicationUpdater updater() {
        return Application.updater(this.appId);
    }

    public ApplicationDeleter deleter() {
        return Application.deleter(this.appId);
    }

    @Override
    public String getId() {
        return this.getAppId();
    }
}

