/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.common.utils;

import com.playtika.test.common.properties.InstallPackageProperties;
import com.playtika.test.common.utils.ContainerUtils;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.ContainerState;
import org.testcontainers.containers.GenericContainer;

@Deprecated
public abstract class PackageInstaller {
    private static final Logger log = LoggerFactory.getLogger(PackageInstaller.class);
    private final InstallPackageProperties properties;
    private final GenericContainer container;

    protected abstract void install(String var1);

    @PostConstruct
    protected void installPackages() {
        String dockerImageName = this.container.getDockerImageName();
        String containerName = this.container.getContainerInfo().getName();
        if (!this.properties.isEnabled()) {
            log.trace("Packages installation skipped for container: {} docker image: {}", (Object)containerName, (Object)dockerImageName);
            return;
        }
        if (this.properties.getPackages().isEmpty()) {
            log.trace("No packages configured to be installed into container: {} docker image: {}", (Object)containerName, (Object)dockerImageName);
            return;
        }
        log.info("Updating package lists in container: {} docker image: {}", (Object)containerName, (Object)dockerImageName);
        this.updatePackageList();
        log.info("Installing packages: {} into container: {} docker image: {}", new Object[]{this.properties.getPackages(), containerName, dockerImageName});
        this.properties.getPackages().forEach(this::installPackageIfNeeded);
        log.info("Installed packages: {} into container: {} docker image: {}", new Object[]{this.properties.getPackages(), containerName, dockerImageName});
    }

    protected void updatePackageList() {
    }

    protected void installPackageIfNeeded(String packageToInstall) {
        if (this.shouldInstall(packageToInstall)) {
            this.install(packageToInstall);
        }
    }

    protected boolean shouldInstall(String packageToInstall) {
        Container.ExecResult result = ContainerUtils.executeInContainer((ContainerState)this.container, "which", packageToInstall);
        return result.getStdout().isEmpty();
    }

    protected Container.ExecResult executeCommandAndCheckExitCode(String ... command) {
        return ContainerUtils.executeAndCheckExitCode((ContainerState)this.container, command);
    }

    public PackageInstaller(InstallPackageProperties properties, GenericContainer container) {
        this.properties = properties;
        this.container = container;
    }
}

