/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.keycloak;

import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import com.playtika.testcontainer.common.utils.ContainerUtils;
import com.playtika.testcontainer.keycloak.KeycloakContainer;
import com.playtika.testcontainer.keycloak.KeycloakProperties;
import java.util.LinkedHashMap;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ResourceLoader;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;

public class KeycloakContainerFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KeycloakContainerFactory.class);
    private static final String KEYCLOAK_NETWORK_ALIAS = "keycloak.testcontainer.docker";
    private final ConfigurableEnvironment environment;
    private final KeycloakProperties properties;
    private final ResourceLoader resourceLoader;
    private final Optional<Network> network;

    public KeycloakContainer newKeycloakContainer() {
        KeycloakContainer keycloak = (KeycloakContainer)new KeycloakContainer(this.properties, this.resourceLoader).withNetworkAliases(new String[]{KEYCLOAK_NETWORK_ALIAS});
        this.network.ifPresent(arg_0 -> ((KeycloakContainer)keycloak).withNetwork(arg_0));
        keycloak = (KeycloakContainer)ContainerUtils.configureCommonsAndStart((GenericContainer)keycloak, (CommonContainerProperties)this.properties, (Logger)log);
        this.registerKeycloakEnvironment(keycloak);
        return keycloak;
    }

    private void registerKeycloakEnvironment(KeycloakContainer keycloak) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.keycloak.host", keycloak.getIp());
        map.put("embedded.keycloak.http-port", keycloak.getHttpPort());
        map.put("embedded.keycloak.auth-server-url", keycloak.getAuthServerUrl());
        map.put("embedded.keycloak.networkAlias", KEYCLOAK_NETWORK_ALIAS);
        map.put("embedded.keycloak.internalPort", 8080);
        log.info("Started Keycloak server. Connection details: {}", map);
        MapPropertySource propertySource = new MapPropertySource("embeddedKeycloakInfo", map);
        this.environment.getPropertySources().addFirst((PropertySource)propertySource);
    }

    @Generated
    public KeycloakContainerFactory(ConfigurableEnvironment environment, KeycloakProperties properties, ResourceLoader resourceLoader, Optional<Network> network) {
        this.environment = environment;
        this.properties = properties;
        this.resourceLoader = resourceLoader;
        this.network = network;
    }
}

