/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.keycloak;

import com.playtika.test.common.properties.CommonContainerProperties;
import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.keycloak.KeycloakContainer;
import com.playtika.test.keycloak.KeycloakProperties;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ResourceLoader;
import org.testcontainers.containers.GenericContainer;

public class KeycloakContainerFactory {
    private static final Logger log = LoggerFactory.getLogger(KeycloakContainerFactory.class);
    private final ConfigurableEnvironment environment;
    private final KeycloakProperties properties;
    private final ResourceLoader resourceLoader;

    public KeycloakContainer newKeycloakContainer() {
        KeycloakContainer keycloak = new KeycloakContainer(this.properties, this.resourceLoader);
        keycloak = (KeycloakContainer)ContainerUtils.configureCommonsAndStart((GenericContainer)keycloak, (CommonContainerProperties)this.properties, (Logger)log);
        this.registerKeycloakEnvironment(keycloak);
        return keycloak;
    }

    private void registerKeycloakEnvironment(KeycloakContainer keycloak) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.keycloak.host", keycloak.getIp());
        map.put("embedded.keycloak.http-port", keycloak.getHttpPort());
        map.put("embedded.keycloak.auth-server-url", keycloak.getAuthServerUrl());
        log.info("Started Keycloak server. Connection details: {}", map);
        MapPropertySource propertySource = new MapPropertySource("embeddedKeycloakInfo", map);
        this.environment.getPropertySources().addFirst((PropertySource)propertySource);
    }

    public KeycloakContainerFactory(ConfigurableEnvironment environment, KeycloakProperties properties, ResourceLoader resourceLoader) {
        this.environment = environment;
        this.properties = properties;
        this.resourceLoader = resourceLoader;
    }
}

