/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.keycloak;

import com.playtika.test.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.test.keycloak.KeycloakContainer;
import com.playtika.test.keycloak.KeycloakContainerFactory;
import com.playtika.test.keycloak.KeycloakProperties;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.ResourceLoader;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@EnableConfigurationProperties(value={KeycloakProperties.class})
@ConditionalOnProperty(name={"embedded.keycloak.enabled"}, matchIfMissing=true)
public class EmbeddedKeycloakBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedKeycloakBootstrapConfiguration.class);

    @Bean
    public KeycloakContainerFactory keycloakContainerFactory(ConfigurableEnvironment environment, KeycloakProperties properties, ResourceLoader resourceLoader) {
        return new KeycloakContainerFactory(environment, properties, resourceLoader);
    }

    @Bean(name={"embeddedKeycloak"}, destroyMethod="stop")
    public KeycloakContainer keycloakContainer(KeycloakContainerFactory factory) {
        log.info("Detected keycloak-spring-boot-adapter, ");
        return Objects.requireNonNull(factory).newKeycloakContainer();
    }
}

