/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.webclient.client;

import feign.MethodMetadata;
import feign.Util;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactivefeign.client.ReactiveFeignException;
import reactivefeign.client.ReactiveHttpClient;
import reactivefeign.client.ReactiveHttpRequest;
import reactivefeign.client.ReactiveHttpResponse;
import reactivefeign.client.ReadTimeoutException;
import reactivefeign.utils.FeignUtils;
import reactivefeign.webclient.client.WebReactiveHttpResponse;
import reactor.core.publisher.Mono;

public class WebReactiveHttpClient
implements ReactiveHttpClient {
    private final WebClient webClient;
    private final ParameterizedTypeReference<Object> bodyActualType;
    private final Type returnPublisherType;
    private final ParameterizedTypeReference<Object> returnActualType;

    public static WebReactiveHttpClient webClient(MethodMetadata methodMetadata, WebClient webClient) {
        Type returnType = methodMetadata.returnType();
        Type returnPublisherType = ((ParameterizedType)returnType).getRawType();
        ParameterizedTypeReference returnActualType = ParameterizedTypeReference.forType((Type)Util.resolveLastTypeParameter((Type)returnType, (Class)((Class)returnPublisherType)));
        ParameterizedTypeReference bodyActualType = Optional.ofNullable(FeignUtils.getBodyActualType((Type)methodMetadata.bodyType())).map(type -> ParameterizedTypeReference.forType((Type)type)).orElse(null);
        return new WebReactiveHttpClient(webClient, (ParameterizedTypeReference<Object>)bodyActualType, returnPublisherType, (ParameterizedTypeReference<Object>)returnActualType);
    }

    public WebReactiveHttpClient(WebClient webClient, ParameterizedTypeReference<Object> bodyActualType, Type returnPublisherType, ParameterizedTypeReference<Object> returnActualType) {
        this.webClient = webClient;
        this.bodyActualType = bodyActualType;
        this.returnPublisherType = returnPublisherType;
        this.returnActualType = returnActualType;
    }

    public Mono<ReactiveHttpResponse> executeRequest(ReactiveHttpRequest request) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.method(HttpMethod.valueOf((String)request.method())).uri(request.uri())).headers(httpHeaders -> this.setUpHeaders(request, (HttpHeaders)httpHeaders))).body(this.provideBody(request)).exchange().onErrorMap(ex -> {
            if (ex instanceof io.netty.handler.timeout.ReadTimeoutException) {
                return new ReadTimeoutException(ex, request);
            }
            return new ReactiveFeignException(ex, request);
        }).map(response -> new WebReactiveHttpResponse(request, (ClientResponse)response, this.returnPublisherType, this.returnActualType));
    }

    protected BodyInserter<?, ? super ClientHttpRequest> provideBody(ReactiveHttpRequest request) {
        return this.bodyActualType != null ? BodyInserters.fromPublisher((Publisher)request.body(), this.bodyActualType) : BodyInserters.empty();
    }

    protected void setUpHeaders(ReactiveHttpRequest request, HttpHeaders httpHeaders) {
        request.headers().forEach((arg_0, arg_1) -> ((HttpHeaders)httpHeaders).put(arg_0, arg_1));
    }
}

