/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.webclient.jetty;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import org.eclipse.jetty.client.Request;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientRequestException;
import reactivefeign.ReactiveOptions;
import reactivefeign.client.ReactiveHttpRequest;
import reactivefeign.client.ReadTimeoutException;
import reactivefeign.webclient.CoreWebBuilder;
import reactivefeign.webclient.WebClientFeignCustomizer;
import reactivefeign.webclient.jetty.JettyClientHttpConnectorBuilder;
import reactivefeign.webclient.jetty.JettyReactiveOptions;

public class JettyWebReactiveFeign {
    public static <T> Builder<T> builder() {
        return JettyWebReactiveFeign.builder(WebClient.builder());
    }

    public static <T> Builder<T> builder(WebClient.Builder webClientBuilder) {
        return new Builder(webClientBuilder);
    }

    public static <T> Builder<T> builder(WebClient.Builder webClientBuilder, WebClientFeignCustomizer webClientCustomizer) {
        return new Builder(webClientBuilder, webClientCustomizer);
    }

    public static class Builder<T>
    extends CoreWebBuilder<T> {
        private JettyReactiveOptions reactiveOptions = JettyReactiveOptions.DEFAULT_OPTIONS;

        protected Builder(WebClient.Builder webClientBuilder) {
            super(webClientBuilder);
        }

        protected Builder(WebClient.Builder webClientBuilder, WebClientFeignCustomizer webClientCustomizer) {
            super(webClientBuilder, webClientCustomizer);
        }

        public Builder<T> options(ReactiveOptions options) {
            this.reactiveOptions = (JettyReactiveOptions)options;
            return this;
        }

        public BiFunction<ReactiveHttpRequest, Throwable, Throwable> errorMapper() {
            return (request, throwable) -> {
                if (throwable instanceof WebClientRequestException && throwable.getCause() instanceof TimeoutException) {
                    return new ReadTimeoutException(throwable, request);
                }
                return null;
            };
        }

        protected ClientHttpConnector clientConnector() {
            Long requestTimeoutMillis = this.reactiveOptions.getRequestTimeoutMillis();
            if (requestTimeoutMillis != null) {
                this.webClientBuilder.filter((request, next) -> next.exchange(ClientRequest.from((ClientRequest)request).httpRequest(clientHttpRequest -> ((Request)clientHttpRequest.getNativeRequest()).timeout(requestTimeoutMillis.longValue(), TimeUnit.MILLISECONDS)).build()));
            }
            return JettyClientHttpConnectorBuilder.buildJettyClientHttpConnector(this.reactiveOptions);
        }
    }
}

