/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.webclient.jetty;

import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.transport.HttpClientTransportOverHTTP2;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.JettyClientHttpConnector;
import reactivefeign.ReactiveOptions;
import reactivefeign.webclient.jetty.JettyReactiveOptions;

class JettyClientHttpConnectorBuilder {
    JettyClientHttpConnectorBuilder() {
    }

    public static ClientHttpConnector buildJettyClientHttpConnector(JettyReactiveOptions options) {
        HttpClient httpClient;
        boolean useHttp2 = ReactiveOptions.useHttp2((ReactiveOptions)options);
        if (useHttp2) {
            HTTP2Client h2Client = new HTTP2Client();
            h2Client.setSelectors(1);
            HttpClientTransportOverHTTP2 transport = new HttpClientTransportOverHTTP2(h2Client);
            httpClient = new HttpClient((HttpClientTransport)transport);
        } else {
            httpClient = new HttpClient();
        }
        try {
            httpClient.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (options.getConnectTimeoutMillis() != null) {
            httpClient.setConnectTimeout(options.getConnectTimeoutMillis().longValue());
        }
        if (options.isFollowRedirects() != null) {
            httpClient.setFollowRedirects(options.isFollowRedirects().booleanValue());
        }
        if (options.getProxySettings() != null) {
            ReactiveOptions.ProxySettings proxySettings = options.getProxySettings();
            httpClient.getProxyConfiguration().addProxy((ProxyConfiguration.Proxy)new HttpProxy(proxySettings.getHost(), proxySettings.getPort()));
        }
        return new JettyClientHttpConnector(httpClient);
    }
}

