/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.webclient.jetty;

import feign.MethodMetadata;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import org.eclipse.jetty.client.api.Request;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientRequestException;
import reactivefeign.ReactiveFeign;
import reactivefeign.ReactiveOptions;
import reactivefeign.client.ReactiveHttpRequest;
import reactivefeign.client.ReadTimeoutException;
import reactivefeign.webclient.CustomizableWebClientBuilder;
import reactivefeign.webclient.WebClientFeignCustomizer;
import reactivefeign.webclient.client.WebReactiveHttpClient;
import reactivefeign.webclient.jetty.JettyClientHttpConnectorBuilder;
import reactivefeign.webclient.jetty.JettyReactiveOptions;

public class JettyWebReactiveFeign {
    public static <T> Builder<T> builder() {
        return JettyWebReactiveFeign.builder(WebClient.builder());
    }

    public static <T> Builder<T> builder(WebClient.Builder webClientBuilder) {
        return new Builder(webClientBuilder);
    }

    public static <T> Builder<T> builder(WebClient.Builder webClientBuilder, WebClientFeignCustomizer webClientCustomizer) {
        return new Builder(webClientBuilder, webClientCustomizer);
    }

    public static class Builder<T>
    extends ReactiveFeign.Builder<T> {
        protected CustomizableWebClientBuilder webClientBuilder;

        protected Builder(WebClient.Builder webClientBuilder) {
            this.webClientBuilder = new CustomizableWebClientBuilder(webClientBuilder);
            this.webClientBuilder.clientConnector(JettyClientHttpConnectorBuilder.buildJettyClientHttpConnector(JettyReactiveOptions.DEFAULT_OPTIONS));
            this.updateClientFactory();
        }

        protected Builder(WebClient.Builder webClientBuilder, WebClientFeignCustomizer webClientCustomizer) {
            this.webClientBuilder = new CustomizableWebClientBuilder(webClientBuilder);
            this.webClientBuilder.clientConnector(JettyClientHttpConnectorBuilder.buildJettyClientHttpConnector(JettyReactiveOptions.DEFAULT_OPTIONS));
            webClientCustomizer.accept((Object)this.webClientBuilder);
            this.updateClientFactory();
        }

        public Builder<T> options(ReactiveOptions options) {
            this.webClientBuilder.clientConnector(JettyClientHttpConnectorBuilder.buildJettyClientHttpConnector((JettyReactiveOptions)options));
            Long requestTimeoutMillis = ((JettyReactiveOptions)options).getRequestTimeoutMillis();
            if (requestTimeoutMillis != null) {
                this.webClientBuilder.filter((request, next) -> next.exchange(ClientRequest.from((ClientRequest)request).httpRequest(clientHttpRequest -> ((Request)clientHttpRequest.getNativeRequest()).timeout(requestTimeoutMillis.longValue(), TimeUnit.MILLISECONDS)).build()));
            }
            this.updateClientFactory();
            return this;
        }

        protected void updateClientFactory() {
            this.clientFactory(methodMetadata -> WebReactiveHttpClient.webClient((MethodMetadata)methodMetadata, (WebClient)this.webClientBuilder.build(), Builder.errorMapper()));
        }

        public static BiFunction<ReactiveHttpRequest, Throwable, Throwable> errorMapper() {
            return (request, throwable) -> {
                if (throwable instanceof WebClientRequestException && throwable.getCause() instanceof TimeoutException) {
                    return new ReadTimeoutException(throwable, request);
                }
                return null;
            };
        }
    }
}

