/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.webclient.client5;

import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.H2AsyncClientBuilder;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.routing.DefaultProxyRoutePlanner;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.core5.http.HttpHost;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.HttpComponentsClientHttpConnector;
import reactivefeign.ReactiveOptions;
import reactivefeign.webclient.client5.HttpClient5ReactiveOptions;

class HttpClient5HttpConnectorBuilder {
    HttpClient5HttpConnectorBuilder() {
    }

    public static ClientHttpConnector buildHttp5ClientHttpConnector(HttpClient5ReactiveOptions options) {
        CloseableHttpAsyncClient client;
        RequestConfig requestConfig = HttpClient5HttpConnectorBuilder.buildRequestConfig(options);
        if (ReactiveOptions.useHttp2((ReactiveOptions)options)) {
            H2AsyncClientBuilder clientBuilder = HttpAsyncClients.customHttp2().setDefaultRequestConfig(requestConfig).disableAutomaticRetries();
            ReactiveOptions.ProxySettings proxySettings = options.getProxySettings();
            if (proxySettings != null) {
                clientBuilder = clientBuilder.setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(new HttpHost(proxySettings.getHost(), proxySettings.getPort())));
            }
            client = clientBuilder.build();
        } else {
            ReactiveOptions.ProxySettings proxySettings;
            HttpAsyncClientBuilder clientBuilder = HttpAsyncClients.custom().setDefaultRequestConfig(requestConfig).disableAutomaticRetries();
            clientBuilder = clientBuilder.setConnectionManager((AsyncClientConnectionManager)HttpClient5HttpConnectorBuilder.buildConnectionManager(options));
            if (options != null && (proxySettings = options.getProxySettings()) != null) {
                clientBuilder = clientBuilder.setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(new HttpHost(proxySettings.getHost(), proxySettings.getPort())));
            }
            client = clientBuilder.build();
        }
        return new HttpComponentsClientHttpConnector(client);
    }

    private static PoolingAsyncClientConnectionManager buildConnectionManager(HttpClient5ReactiveOptions options) {
        PoolingAsyncClientConnectionManager connectionManager = new PoolingAsyncClientConnectionManager();
        if (options != null) {
            if (options.getConnectionsDefaultMaxPerRoute() != null) {
                connectionManager.setDefaultMaxPerRoute(options.getConnectionsDefaultMaxPerRoute().intValue());
            }
            if (options.getConnectionsMaxTotal() != null) {
                connectionManager.setMaxTotal(options.getConnectionsMaxTotal().intValue());
            }
        }
        return connectionManager;
    }

    private static RequestConfig buildRequestConfig(HttpClient5ReactiveOptions options) {
        RequestConfig.Builder configBuilder;
        RequestConfig.Builder builder = configBuilder = options != null && options.getRequestConfig() != null ? RequestConfig.copy((RequestConfig)options.getRequestConfig()) : RequestConfig.custom();
        if (options != null) {
            if (options.getConnectTimeoutMillis() != null) {
                configBuilder = configBuilder.setConnectTimeout(options.getConnectTimeoutMillis().longValue(), TimeUnit.MILLISECONDS);
            }
            if (options.getSocketTimeoutMillis() != null) {
                configBuilder = configBuilder.setResponseTimeout((long)options.getSocketTimeoutMillis().intValue(), TimeUnit.MILLISECONDS);
            }
            if (options.isFollowRedirects() != null) {
                configBuilder = configBuilder.setRedirectsEnabled(options.isFollowRedirects().booleanValue());
            }
            if (options.isTryUseCompression() != null) {
                configBuilder = configBuilder.setContentCompressionEnabled(options.isTryUseCompression().booleanValue());
            }
        }
        return configBuilder.build();
    }
}

