/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.rx3.methodhandler;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Single;
import java.lang.reflect.Type;
import org.reactivestreams.Publisher;
import reactivefeign.methodhandler.MethodHandler;
import reactor.adapter.rxjava.RxJava3Adapter;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class Rx3MethodHandler
implements MethodHandler {
    private final MethodHandler methodHandler;
    private final Type returnPublisherType;

    public Rx3MethodHandler(MethodHandler methodHandler, Type returnPublisherType) {
        this.methodHandler = methodHandler;
        this.returnPublisherType = returnPublisherType;
    }

    public Object invoke(Object[] argv) {
        try {
            Publisher publisher = (Publisher)this.methodHandler.invoke(argv);
            if (this.returnPublisherType == Flowable.class) {
                return RxJava3Adapter.fluxToFlowable((Flux)Flux.from((Publisher)publisher));
            }
            if (this.returnPublisherType == Observable.class) {
                return RxJava3Adapter.fluxToObservable((Flux)Flux.from((Publisher)publisher));
            }
            if (this.returnPublisherType == Single.class) {
                return RxJava3Adapter.monoToSingle((Mono)Mono.from((Publisher)publisher));
            }
            if (this.returnPublisherType == Maybe.class) {
                return RxJava3Adapter.monoToMaybe((Mono)Mono.from((Publisher)publisher));
            }
            throw new IllegalArgumentException("Unexpected returnPublisherType=" + this.returnPublisherType.getClass());
        }
        catch (Throwable throwable) {
            if (this.returnPublisherType == Flowable.class) {
                return Flowable.error((Throwable)throwable);
            }
            if (this.returnPublisherType == Observable.class) {
                return Observable.error((Throwable)throwable);
            }
            if (this.returnPublisherType == Single.class) {
                return Single.error((Throwable)throwable);
            }
            if (this.returnPublisherType == Maybe.class) {
                return Maybe.error((Throwable)throwable);
            }
            throw new IllegalArgumentException("Unexpected returnPublisherType=" + this.returnPublisherType.getClass());
        }
    }
}

