/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.rx3;

import feign.Contract;
import feign.MethodMetadata;
import feign.Util;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Single;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Rx3Contract
implements Contract {
    public static final Set<Type> RX3_TYPES = new HashSet<Class>(Arrays.asList(Flowable.class, Observable.class, Single.class, Maybe.class));
    private final Contract delegate;

    public Rx3Contract(Contract delegate) {
        this.delegate = (Contract)Util.checkNotNull((Object)delegate, (String)"delegate must not be null", (Object[])new Object[0]);
    }

    public List<MethodMetadata> parseAndValidateMetadata(Class<?> targetType) {
        List methodsMetadata = this.delegate.parseAndValidateMetadata(targetType);
        for (MethodMetadata metadata : methodsMetadata) {
            Type type = metadata.returnType();
            if (this.isRx3Type(type)) continue;
            throw new IllegalArgumentException(String.format("Method %s of contract %s doesn't returns rx3 types", metadata.configKey(), targetType.getSimpleName()));
        }
        return methodsMetadata;
    }

    private boolean isRx3Type(Type type) {
        return type instanceof ParameterizedType && RX3_TYPES.contains(((ParameterizedType)type).getRawType());
    }
}

