/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.rx2.client.statushandler;

import io.reactivex.Single;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import reactivefeign.client.ReactiveHttpResponse;
import reactivefeign.rx2.client.statushandler.Rx2StatusHandler;

public final class Rx2StatusHandlers {
    private Rx2StatusHandlers() {
    }

    public static Rx2StatusHandler throwOnStatus(final Predicate<Integer> statusPredicate, final BiFunction<String, ReactiveHttpResponse, Throwable> errorFunction) {
        return new Rx2StatusHandler(){

            @Override
            public boolean shouldHandle(int status) {
                return statusPredicate.test(status);
            }

            @Override
            public Single<? extends Throwable> decode(String methodKey, ReactiveHttpResponse response) {
                return Single.just((Object)((Throwable)errorFunction.apply(methodKey, response)));
            }
        };
    }
}

