/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.rx2;

import feign.Contract;
import feign.MethodMetadata;
import feign.Util;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.Observable;
import io.reactivex.Single;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Rx2Contract
implements Contract {
    public static final Set<Type> RX2_TYPES = new HashSet<Class>(Arrays.asList(Flowable.class, Observable.class, Single.class, Maybe.class));
    private final Contract delegate;

    public Rx2Contract(Contract delegate) {
        this.delegate = (Contract)Util.checkNotNull((Object)delegate, (String)"delegate must not be null", (Object[])new Object[0]);
    }

    public List<MethodMetadata> parseAndValidateMetadata(Class<?> targetType) {
        List methodsMetadata = this.delegate.parseAndValidateMetadata(targetType);
        for (MethodMetadata metadata : methodsMetadata) {
            Type type = metadata.returnType();
            if (this.isRx2Type(type)) continue;
            throw new IllegalArgumentException(String.format("Method %s of contract %s doesn't returns rx2 types", metadata.configKey(), targetType.getSimpleName()));
        }
        return methodsMetadata;
    }

    private boolean isRx2Type(Type type) {
        return type instanceof ParameterizedType && RX2_TYPES.contains(((ParameterizedType)type).getRawType());
    }
}

