/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.rx2.methodhandler;

import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.Observable;
import io.reactivex.Single;
import java.lang.reflect.Type;
import org.reactivestreams.Publisher;
import reactivefeign.methodhandler.MethodHandler;
import reactor.adapter.rxjava.RxJava2Adapter;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class Rx2MethodHandler
implements MethodHandler {
    private final MethodHandler methodHandler;
    private final Type returnPublisherType;

    public Rx2MethodHandler(MethodHandler methodHandler, Type returnPublisherType) {
        this.methodHandler = methodHandler;
        this.returnPublisherType = returnPublisherType;
    }

    public Object invoke(Object[] argv) {
        try {
            Publisher publisher = (Publisher)this.methodHandler.invoke(argv);
            if (this.returnPublisherType == Flowable.class) {
                return RxJava2Adapter.fluxToFlowable((Flux)((Flux)publisher));
            }
            if (this.returnPublisherType == Observable.class) {
                return RxJava2Adapter.fluxToObservable((Flux)((Flux)publisher));
            }
            if (this.returnPublisherType == Single.class) {
                return RxJava2Adapter.monoToSingle((Mono)((Mono)publisher));
            }
            if (this.returnPublisherType == Maybe.class) {
                return RxJava2Adapter.monoToMaybe((Mono)((Mono)publisher));
            }
            throw new IllegalArgumentException("Unexpected returnPublisherType=" + this.returnPublisherType.getClass());
        }
        catch (Throwable throwable) {
            if (this.returnPublisherType == Flowable.class) {
                return Flowable.error((Throwable)throwable);
            }
            if (this.returnPublisherType == Observable.class) {
                return Observable.error((Throwable)throwable);
            }
            if (this.returnPublisherType == Single.class) {
                return Single.error((Throwable)throwable);
            }
            if (this.returnPublisherType == Maybe.class) {
                return Maybe.error((Throwable)throwable);
            }
            throw new IllegalArgumentException("Unexpected returnPublisherType=" + this.returnPublisherType.getClass());
        }
    }
}

