/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.cloud2;

import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Contract;
import feign.MethodMetadata;
import feign.Target;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import reactivefeign.FallbackFactory;
import reactivefeign.ReactiveFeign;
import reactivefeign.ReactiveFeignBuilder;
import reactivefeign.ReactiveOptions;
import reactivefeign.client.ReactiveHttpExchangeFilterFunction;
import reactivefeign.client.ReactiveHttpRequestInterceptor;
import reactivefeign.client.ReactiveHttpResponseMapper;
import reactivefeign.client.log.ReactiveLoggerListener;
import reactivefeign.client.statushandler.ReactiveStatusHandler;
import reactivefeign.cloud2.ReactiveFeignCircuitBreakerFactory;
import reactivefeign.cloud2.methodhandler.CircuitBreakerMethodHandlerFactory;
import reactivefeign.cloud2.publisher.LoadBalancerPublisherClient;
import reactivefeign.methodhandler.MethodHandlerFactory;
import reactivefeign.publisher.PublisherClientFactory;
import reactivefeign.publisher.PublisherHttpClient;
import reactivefeign.retry.ReactiveRetryPolicy;
import reactor.util.retry.Retry;

public class CloudReactiveFeign {
    private static final Logger logger = LoggerFactory.getLogger(CloudReactiveFeign.class);

    public static <T> Builder<T> builder(ReactiveFeignBuilder<T> builder) {
        return new Builder<T>(builder);
    }

    public static class Builder<T>
    implements ReactiveFeignBuilder<T> {
        private ReactiveFeignBuilder<T> builder;
        private ReactiveFeignCircuitBreakerFactory circuitBreakerFactory;
        private FallbackFactory<T> fallbackFactory;
        private ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerFactory;
        private ReactiveRetryPolicy retryOnNextPolicy;

        protected Builder(ReactiveFeignBuilder<T> builder) {
            this.builder = builder;
        }

        public Builder<T> enableCircuitBreaker(ReactiveFeignCircuitBreakerFactory circuitBreakerFactory) {
            this.circuitBreakerFactory = circuitBreakerFactory;
            return this;
        }

        public Builder<T> enableLoadBalancer(ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerFactory) {
            this.loadBalancerFactory = loadBalancerFactory;
            return this;
        }

        public Builder<T> retryOnSame(ReactiveRetryPolicy retryOnSamePolicy) {
            if (this.loadBalancerFactory == null) {
                throw new IllegalArgumentException("loadBalancerFactory should be specified");
            }
            this.retryWhen(retryOnSamePolicy);
            return this;
        }

        public Builder<T> retryOnNext(ReactiveRetryPolicy retryOnNextPolicy) {
            if (this.loadBalancerFactory == null) {
                throw new IllegalArgumentException("loadBalancerFactory should be specified");
            }
            this.retryOnNextPolicy = retryOnNextPolicy;
            return this;
        }

        public Builder<T> fallback(T fallback) {
            return this.fallbackFactory(throwable -> fallback);
        }

        public Builder<T> fallbackFactory(FallbackFactory<T> fallbackFactory) {
            this.fallbackFactory = fallbackFactory;
            return this;
        }

        public Builder<T> contract(Contract contract) {
            this.builder = this.builder.contract(contract);
            return this;
        }

        public ReactiveFeignBuilder<T> addExchangeFilterFunction(ReactiveHttpExchangeFilterFunction exchangeFilterFunction) {
            this.builder = this.builder.addExchangeFilterFunction(exchangeFilterFunction);
            return this;
        }

        public Builder<T> options(ReactiveOptions options) {
            this.builder = this.builder.options(options);
            return this;
        }

        public Builder<T> addRequestInterceptor(ReactiveHttpRequestInterceptor requestInterceptor) {
            this.builder = this.builder.addRequestInterceptor(requestInterceptor);
            return this;
        }

        public Builder<T> addLoggerListener(ReactiveLoggerListener loggerListener) {
            this.builder = this.builder.addLoggerListener(loggerListener);
            return this;
        }

        public Builder<T> decode404() {
            this.builder = this.builder.decode404();
            return this;
        }

        public Builder<T> statusHandler(ReactiveStatusHandler statusHandler) {
            this.builder = this.builder.statusHandler(statusHandler);
            return this;
        }

        public ReactiveFeignBuilder<T> objectMapper(ObjectMapper objectMapper) {
            this.builder = this.builder.objectMapper(objectMapper);
            return this;
        }

        public Builder<T> responseMapper(ReactiveHttpResponseMapper responseMapper) {
            this.builder = this.builder.responseMapper(responseMapper);
            return this;
        }

        public Builder<T> retryWhen(ReactiveRetryPolicy retryPolicy) {
            this.builder = this.builder.retryWhen(retryPolicy);
            return this;
        }

        public Contract contract() {
            return this.builder.contract();
        }

        public MethodHandlerFactory buildReactiveMethodHandlerFactory(PublisherClientFactory reactiveClientFactory) {
            if (this.circuitBreakerFactory == null) {
                this.builder.fallbackFactory(this.fallbackFactory);
                return this.builder.buildReactiveMethodHandlerFactory(reactiveClientFactory);
            }
            return new CircuitBreakerMethodHandlerFactory(this.builder.buildReactiveMethodHandlerFactory(reactiveClientFactory), this.circuitBreakerFactory, (Function<Throwable, Object>)this.fallbackFactory);
        }

        public PublisherClientFactory buildReactiveClientFactory() {
            final PublisherClientFactory publisherClientFactory = this.builder.buildReactiveClientFactory();
            return new PublisherClientFactory(){
                private Target target;

                public void target(Target target) {
                    this.target = target;
                    publisherClientFactory.target(target);
                }

                public PublisherHttpClient create(MethodMetadata methodMetadata) {
                    PublisherHttpClient publisherClient = publisherClientFactory.create(methodMetadata);
                    if (!this.target.name().equals(this.target.url()) && loadBalancerFactory != null) {
                        publisherClient = new LoadBalancerPublisherClient((ReactiveLoadBalancer<ServiceInstance>)loadBalancerFactory.getInstance(this.target.name()), publisherClient);
                        if (retryOnNextPolicy != null) {
                            publisherClient = ReactiveFeign.Builder.retry((PublisherHttpClient)publisherClient, (MethodMetadata)methodMetadata, (Retry)retryOnNextPolicy.retry());
                        }
                        return publisherClient;
                    }
                    if (retryOnNextPolicy != null) {
                        logger.warn("retryOnNextPolicy will be ignored as loadBalancerFactory is not configured for {} reactive feign client", (Object)this.target.name());
                    }
                    return publisherClient;
                }
            };
        }
    }
}

