/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.cloud.methodhandler;

import com.netflix.hystrix.HystrixObservableCommand;
import feign.MethodMetadata;
import feign.Target;
import feign.Util;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactivefeign.cloud.CloudReactiveFeign;
import reactivefeign.cloud.SubscriberContextUtils;
import reactivefeign.methodhandler.MethodHandler;
import reactivefeign.utils.FeignUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;
import rx.Observable;
import rx.RxReactiveStreams;
import rx.Single;

public class HystrixMethodHandler
implements MethodHandler {
    private final Method method;
    private final Type returnPublisherType;
    private final MethodHandler methodHandler;
    private final Function<Throwable, Object> fallbackFactory;
    private final HystrixObservableCommand.Setter hystrixObservableCommandSetter;

    HystrixMethodHandler(Target target, MethodMetadata methodMetadata, MethodHandler methodHandler, CloudReactiveFeign.SetterFactory setterFactory, Function<Throwable, Object> fallbackFactory) {
        Util.checkNotNull((Object)target, (String)"target must be not null", (Object[])new Object[0]);
        Util.checkNotNull((Object)methodMetadata, (String)"methodMetadata must be not null", (Object[])new Object[0]);
        this.method = FeignUtils.findMethodInTarget((Target)target, (MethodMetadata)methodMetadata);
        this.method.setAccessible(true);
        this.returnPublisherType = ((ParameterizedType)methodMetadata.returnType()).getRawType();
        this.methodHandler = (MethodHandler)Util.checkNotNull((Object)methodHandler, (String)"methodHandler must be not null", (Object[])new Object[0]);
        this.fallbackFactory = fallbackFactory;
        Util.checkNotNull((Object)setterFactory, (String)"setterFactory must be not null", (Object[])new Object[0]);
        this.hystrixObservableCommandSetter = setterFactory.create(target, methodMetadata);
    }

    public Publisher<Object> invoke(Object[] argv) {
        if (this.returnPublisherType == Mono.class) {
            return Mono.subscriberContext().flatMap(context -> Mono.from((Publisher)RxReactiveStreams.toPublisher((Single)this.getHystrixObservableCommand((Context)context, argv).toSingle()))).onErrorResume(throwable -> throwable instanceof NoSuchElementException && throwable.getMessage().equals("Observable emitted no items"), throwable -> Mono.empty());
        }
        if (this.returnPublisherType == Flux.class) {
            return Mono.subscriberContext().flatMapMany(context -> Flux.from((Publisher)RxReactiveStreams.toPublisher(this.getHystrixObservableCommand((Context)context, argv))));
        }
        throw new IllegalArgumentException("Unknown returnPublisherType: " + this.returnPublisherType);
    }

    protected Object getFallbackValue(Object target, Method method, Object[] argv) throws Throwable {
        return method.invoke(target, argv);
    }

    private Observable<Object> getHystrixObservableCommand(final Context context, final Object[] argv) {
        return new HystrixObservableCommand<Object>(this.hystrixObservableCommandSetter){

            protected Observable<Object> construct() {
                try {
                    Publisher publisher = (Publisher)HystrixMethodHandler.this.methodHandler.invoke(argv);
                    return RxReactiveStreams.toObservable((Publisher)SubscriberContextUtils.withContext(publisher, HystrixMethodHandler.this.returnPublisherType, context));
                }
                catch (Throwable throwable) {
                    return Observable.error((Throwable)throwable);
                }
            }

            protected Observable<Object> resumeWithFallback() {
                if (HystrixMethodHandler.this.fallbackFactory != null) {
                    Object fallback = HystrixMethodHandler.this.fallbackFactory.apply(this.getExecutionException());
                    try {
                        Publisher fallbackValue = (Publisher)HystrixMethodHandler.this.getFallbackValue(fallback, HystrixMethodHandler.this.method, argv);
                        return RxReactiveStreams.toObservable((Publisher)SubscriberContextUtils.withContext(fallbackValue, HystrixMethodHandler.this.returnPublisherType, context));
                    }
                    catch (Throwable throwable) {
                        return Observable.error((Throwable)throwable);
                    }
                }
                return super.resumeWithFallback();
            }
        }.toObservable();
    }
}

