/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.cloud.methodhandler;

import feign.MethodMetadata;
import feign.Target;
import feign.Util;
import java.lang.reflect.Method;
import java.util.function.Function;
import reactivefeign.cloud.CloudReactiveFeign;
import reactivefeign.cloud.methodhandler.HystrixMethodHandler;
import reactivefeign.methodhandler.MethodHandler;
import reactivefeign.methodhandler.MethodHandlerFactory;

public class HystrixMethodHandlerFactory
implements MethodHandlerFactory {
    private final MethodHandlerFactory methodHandlerFactory;
    private final CloudReactiveFeign.SetterFactory commandSetterFactory;
    private final Function<Throwable, Object> fallbackFactory;
    private Target target;

    public HystrixMethodHandlerFactory(MethodHandlerFactory methodHandlerFactory, CloudReactiveFeign.SetterFactory commandSetterFactory, Function<Throwable, Object> fallbackFactory) {
        this.methodHandlerFactory = (MethodHandlerFactory)Util.checkNotNull((Object)methodHandlerFactory, (String)"methodHandlerFactory must not be null", (Object[])new Object[0]);
        this.commandSetterFactory = (CloudReactiveFeign.SetterFactory)Util.checkNotNull((Object)commandSetterFactory, (String)"hystrixObservableCommandSetter must not be null", (Object[])new Object[0]);
        this.fallbackFactory = fallbackFactory;
    }

    public void target(Target target) {
        this.target = target;
        this.methodHandlerFactory.target(target);
    }

    public MethodHandler create(MethodMetadata metadata) {
        return new HystrixMethodHandler(this.target, metadata, this.methodHandlerFactory.create(metadata), this.commandSetterFactory, this.fallbackFactory);
    }

    public MethodHandler createDefault(Method method) {
        return this.methodHandlerFactory.createDefault(method);
    }
}

