/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.retry;

import feign.ExceptionPropagationPolicy;
import feign.RetryableException;
import java.time.Clock;
import reactivefeign.retry.ReactiveRetryPolicy;
import reactivefeign.retry.SimpleReactiveRetryPolicy;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class BasicReactiveRetryPolicy
extends SimpleReactiveRetryPolicy {
    private final int maxRetries;
    private final long periodInMs;
    private final Clock clock;

    private BasicReactiveRetryPolicy(int maxRetries, long periodInMs, Clock clock, Scheduler scheduler, ExceptionPropagationPolicy exceptionPropagationPolicy) {
        super(scheduler, exceptionPropagationPolicy);
        this.maxRetries = maxRetries;
        this.periodInMs = periodInMs;
        this.clock = clock;
    }

    public static SimpleReactiveRetryPolicy retry(int maxRetries) {
        return new Builder().setMaxRetries(maxRetries).build();
    }

    public static SimpleReactiveRetryPolicy retryWithBackoff(int maxRetries, long periodInMs) {
        return new Builder().setMaxRetries(maxRetries).setBackoffInMs(periodInMs).build();
    }

    public static SimpleReactiveRetryPolicy retryWithBackoff(int maxRetries, long periodInMs, Scheduler scheduler) {
        return new Builder().setMaxRetries(maxRetries).setBackoffInMs(periodInMs).setScheduler(scheduler).build();
    }

    @Override
    public long retryDelay(Throwable error, int attemptNo) {
        if (attemptNo <= this.maxRetries) {
            if (this.periodInMs > 0L) {
                long delay;
                RetryableException re;
                Long retryAfter;
                if (error instanceof RetryableException && (retryAfter = (re = (RetryableException)error).retryAfter()) != null) {
                    delay = retryAfter - this.clock.millis();
                    delay = Math.min(delay, this.periodInMs);
                    delay = Math.max(delay, 0L);
                } else {
                    delay = this.periodInMs;
                }
                return delay;
            }
            return 0L;
        }
        return -1L;
    }

    @Override
    public int maxAllowedRetries() {
        return this.maxRetries;
    }

    public static class Builder
    implements ReactiveRetryPolicy.Builder {
        private int maxRetries;
        private long backoffInMs = 0L;
        private ExceptionPropagationPolicy exceptionPropagationPolicy;
        private Scheduler scheduler = Schedulers.parallel();
        private Clock clock = Clock.systemUTC();

        public Builder setMaxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder setBackoffInMs(long backoffInMs) {
            this.backoffInMs = backoffInMs;
            return this;
        }

        public Builder setExceptionPropagationPolicy(ExceptionPropagationPolicy exceptionPropagationPolicy) {
            this.exceptionPropagationPolicy = exceptionPropagationPolicy;
            return this;
        }

        Builder setClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        Builder setScheduler(Scheduler scheduler) {
            this.scheduler = scheduler;
            return this;
        }

        @Override
        public BasicReactiveRetryPolicy build() {
            return new BasicReactiveRetryPolicy(this.maxRetries, this.backoffInMs, this.clock, this.scheduler, this.exceptionPropagationPolicy);
        }
    }
}

