/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.filter.reactive;

import java.util.Optional;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public class ServerWebExchangeContextFilter
implements WebFilter {
    public static final String EXCHANGE_CONTEXT_ATTRIBUTE = ServerWebExchangeContextFilter.class.getName() + ".EXCHANGE_CONTEXT";

    @Override
    public Mono<Void> filter(ServerWebExchange exchange2, WebFilterChain chain) {
        return chain.filter(exchange2).contextWrite(context -> context.put(EXCHANGE_CONTEXT_ATTRIBUTE, exchange2));
    }

    public static Optional<ServerWebExchange> getExchange(ContextView contextView) {
        return contextView.getOrEmpty(EXCHANGE_CONTEXT_ATTRIBUTE);
    }

    @Deprecated(since="6.0.6", forRemoval=true)
    public static Optional<ServerWebExchange> get(Context context) {
        return context.getOrEmpty(EXCHANGE_CONTEXT_ATTRIBUTE);
    }
}

