/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.springframework.core.io.InputStreamSource;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class EncodedResource
implements InputStreamSource {
    private final Resource resource;
    @Nullable
    private final String encoding;
    @Nullable
    private final Charset charset;

    public EncodedResource(Resource resource2) {
        this(resource2, null, null);
    }

    public EncodedResource(Resource resource2, @Nullable String encoding) {
        this(resource2, encoding, null);
    }

    public EncodedResource(Resource resource2, @Nullable Charset charset) {
        this(resource2, null, charset);
    }

    private EncodedResource(Resource resource2, @Nullable String encoding, @Nullable Charset charset) {
        Assert.notNull((Object)resource2, "Resource must not be null");
        this.resource = resource2;
        this.encoding = encoding;
        this.charset = charset;
    }

    public final Resource getResource() {
        return this.resource;
    }

    @Nullable
    public final String getEncoding() {
        return this.encoding;
    }

    @Nullable
    public final Charset getCharset() {
        return this.charset;
    }

    public boolean requiresReader() {
        return this.encoding != null || this.charset != null;
    }

    public Reader getReader() throws IOException {
        if (this.charset != null) {
            return new InputStreamReader(this.resource.getInputStream(), this.charset);
        }
        if (this.encoding != null) {
            return new InputStreamReader(this.resource.getInputStream(), this.encoding);
        }
        return new InputStreamReader(this.resource.getInputStream());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.resource.getInputStream();
    }

    public String getContentAsString() throws IOException {
        Charset charset = this.charset != null ? this.charset : (this.encoding != null ? Charset.forName(this.encoding) : Charset.defaultCharset());
        return this.resource.getContentAsString(charset);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof EncodedResource)) return false;
        EncodedResource that = (EncodedResource)other;
        if (!this.resource.equals(that.resource)) return false;
        if (!ObjectUtils.nullSafeEquals(this.charset, that.charset)) return false;
        if (!ObjectUtils.nullSafeEquals(this.encoding, that.encoding)) return false;
        return true;
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public String toString() {
        return this.resource.toString();
    }
}

