/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner.link;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openjdk.jmh.results.BenchmarkResultMetaData;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.runner.ActionPlan;
import org.openjdk.jmh.runner.BenchmarkException;
import org.openjdk.jmh.runner.format.OutputFormat;
import org.openjdk.jmh.runner.link.ActionPlanFrame;
import org.openjdk.jmh.runner.link.ClassConventions;
import org.openjdk.jmh.runner.link.ExceptionFrame;
import org.openjdk.jmh.runner.link.FinishingFrame;
import org.openjdk.jmh.runner.link.HandshakeInitFrame;
import org.openjdk.jmh.runner.link.HandshakeResponseFrame;
import org.openjdk.jmh.runner.link.InfraFrame;
import org.openjdk.jmh.runner.link.OutputFormatFrame;
import org.openjdk.jmh.runner.link.OutputFrame;
import org.openjdk.jmh.runner.link.ResultMetadataFrame;
import org.openjdk.jmh.runner.link.ResultsFrame;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.util.FileUtils;
import org.openjdk.jmh.util.Utils;

public final class BinaryLinkClient {
    private static final int RESET_EACH = Integer.getInteger("jmh.link.resetEach", 100);
    private static final int BUFFER_SIZE = Integer.getInteger("jmh.link.bufferSize", 65536);
    private final Object lock = new Object();
    private final Socket clientSocket;
    private final ObjectOutputStream oos;
    private final ObjectInputStream ois;
    private final ForwardingPrintStream streamErr;
    private final ForwardingPrintStream streamOut;
    private final OutputFormat outputFormat;
    private volatile boolean failed;
    private int resetToGo;
    private final List<Serializable> delayedFrames;
    private boolean inFrame;

    public BinaryLinkClient(String hostName, int hostPort) throws IOException {
        this.clientSocket = new Socket(hostName, hostPort);
        this.oos = new ObjectOutputStream(new BufferedOutputStream(this.clientSocket.getOutputStream(), BUFFER_SIZE));
        this.oos.flush();
        this.ois = new ObjectInputStream(new BufferedInputStream(this.clientSocket.getInputStream(), BUFFER_SIZE));
        this.streamErr = new ForwardingPrintStream(OutputFrame.Type.ERR);
        this.streamOut = new ForwardingPrintStream(OutputFrame.Type.OUT);
        this.outputFormat = (OutputFormat)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{OutputFormat.class}, (proxy, method, args) -> {
            this.pushFrame(new OutputFormatFrame(ClassConventions.getMethodName(method), args));
            return null;
        });
        this.delayedFrames = new ArrayList<Serializable>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushFrame(Serializable frame) throws IOException {
        if (this.failed) {
            throw new IOException("Link had failed already");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.inFrame) {
                this.delayedFrames.add(frame);
                return;
            }
            try {
                this.inFrame = true;
                if (this.resetToGo-- < 0) {
                    this.oos.reset();
                    this.resetToGo = RESET_EACH;
                }
                this.oos.writeObject(frame);
                this.oos.flush();
                while (!this.delayedFrames.isEmpty()) {
                    ArrayList<Serializable> frames = new ArrayList<Serializable>(this.delayedFrames);
                    this.delayedFrames.clear();
                    for (Serializable f : frames) {
                        this.oos.writeObject(f);
                    }
                    this.oos.flush();
                }
            }
            catch (IOException e) {
                this.failed = true;
                throw e;
            }
            finally {
                this.inFrame = false;
            }
        }
    }

    private Object readFrame() throws IOException, ClassNotFoundException {
        try {
            return this.ois.readObject();
        }
        catch (IOException | ClassNotFoundException ex) {
            this.failed = true;
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        FileUtils.safelyClose(this.streamErr);
        FileUtils.safelyClose(this.streamOut);
        Object object = this.lock;
        synchronized (object) {
            this.oos.writeObject(new FinishingFrame());
            FileUtils.safelyClose(this.ois);
            FileUtils.safelyClose(this.oos);
            this.clientSocket.close();
        }
    }

    public Options handshake() throws IOException, ClassNotFoundException {
        Object object = this.lock;
        synchronized (object) {
            this.pushFrame(new HandshakeInitFrame(Utils.getPid()));
            Object reply = this.readFrame();
            if (reply instanceof HandshakeResponseFrame) {
                return ((HandshakeResponseFrame)reply).getOpts();
            }
            throw new IllegalStateException("Got the erroneous reply: " + reply);
        }
    }

    public ActionPlan requestPlan() throws IOException, ClassNotFoundException {
        Object object = this.lock;
        synchronized (object) {
            this.pushFrame(new InfraFrame(InfraFrame.Type.ACTION_PLAN_REQUEST));
            Object reply = this.readFrame();
            if (reply instanceof ActionPlanFrame) {
                return ((ActionPlanFrame)reply).getActionPlan();
            }
            throw new IllegalStateException("Got the erroneous reply: " + reply);
        }
    }

    public void pushResults(IterationResult res) throws IOException {
        this.pushFrame(new ResultsFrame(res));
    }

    public void pushException(BenchmarkException error) throws IOException {
        this.pushFrame(new ExceptionFrame(error));
    }

    public void pushResultMetadata(BenchmarkResultMetaData res) throws IOException {
        this.pushFrame(new ResultMetadataFrame(res));
    }

    public PrintStream getOutStream() {
        return this.streamOut;
    }

    public PrintStream getErrStream() {
        return this.streamErr;
    }

    public OutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    class ForwardingPrintStream
    extends PrintStream {
        public ForwardingPrintStream(final OutputFrame.Type type) {
            super(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    BinaryLinkClient.this.pushFrame(new OutputFrame(type, new byte[]{(byte)(b & 0xFF)}));
                }

                @Override
                public void write(byte[] b) throws IOException {
                    BinaryLinkClient.this.pushFrame(new OutputFrame(type, Arrays.copyOf(b, b.length)));
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    BinaryLinkClient.this.pushFrame(new OutputFrame(type, Arrays.copyOfRange(b, off, len + off)));
                }
            });
        }
    }
}

