/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.internal;

import java.nio.ByteBuffer;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.client.Result;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.reactive.client.ReactiveRequest;
import org.eclipse.jetty.reactive.client.ReactiveResponse;
import org.eclipse.jetty.reactive.client.internal.AbstractEventPublisher;

public class ResponseEventPublisher
extends AbstractEventPublisher<ReactiveResponse.Event>
implements Response.Listener {
    private final ReactiveRequest request;

    public ResponseEventPublisher(ReactiveRequest request) {
        this.request = request;
    }

    @Override
    public void onBegin(Response response) {
        this.emit(new ReactiveResponse.Event(ReactiveResponse.Event.Type.BEGIN, this.request.getReactiveResponse()));
    }

    @Override
    public boolean onHeader(Response response, HttpField field) {
        return true;
    }

    @Override
    public void onHeaders(Response response) {
        this.emit(new ReactiveResponse.Event(ReactiveResponse.Event.Type.HEADERS, this.request.getReactiveResponse()));
    }

    @Override
    public void onContent(Response response, ByteBuffer content) {
    }

    @Override
    public void onContent(Response response, Content.Chunk chunk, Runnable demander) {
    }

    @Override
    public void onContentSource(final Response response, final Content.Source source) {
        Runnable reader = new Runnable(){

            @Override
            public void run() {
                Content.Chunk chunk;
                do {
                    if ((chunk = source.read()) == null) {
                        source.demand(this);
                        return;
                    }
                    if (Content.Chunk.isFailure(chunk)) {
                        ResponseEventPublisher.this.onFailure(response, chunk.getFailure());
                        return;
                    }
                    if (chunk.hasRemaining()) {
                        ResponseEventPublisher.this.emit(new ReactiveResponse.Event(ReactiveResponse.Event.Type.CONTENT, ResponseEventPublisher.this.request.getReactiveResponse(), chunk.getByteBuffer().asReadOnlyBuffer()));
                    }
                    chunk.release();
                } while (!chunk.isLast());
            }
        };
        reader.run();
    }

    @Override
    public void onSuccess(Response response) {
        this.emit(new ReactiveResponse.Event(ReactiveResponse.Event.Type.SUCCESS, this.request.getReactiveResponse()));
    }

    @Override
    public void onFailure(Response response, Throwable failure) {
        this.emit(new ReactiveResponse.Event(ReactiveResponse.Event.Type.FAILURE, this.request.getReactiveResponse(), failure));
    }

    @Override
    public void onComplete(Result result) {
        this.emit(new ReactiveResponse.Event(ReactiveResponse.Event.Type.COMPLETE, this.request.getReactiveResponse()));
        if (result.isSucceeded()) {
            this.succeed();
        } else {
            this.fail(result.getFailure());
        }
    }
}

