/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.eclipse.jetty.util.ByteArrayOutputStream2;

public abstract class WriteThroughWriter
extends Writer {
    static final int DEFAULT_MAX_WRITE_SIZE = 1024;
    private final int _maxWriteSize;
    final OutputStream _out;
    final ByteArrayOutputStream2 _bytes;

    protected WriteThroughWriter(OutputStream out) {
        this(out, 0);
    }

    protected WriteThroughWriter(OutputStream out, int maxWriteSize) {
        this._maxWriteSize = maxWriteSize <= 0 ? 1024 : maxWriteSize;
        this._out = out;
        this._bytes = new ByteArrayOutputStream2(this._maxWriteSize);
    }

    public static WriteThroughWriter newWriter(OutputStream outputStream, String charset) throws IOException {
        if (StandardCharsets.ISO_8859_1.name().equalsIgnoreCase(charset)) {
            return new Iso88591Writer(outputStream);
        }
        if (StandardCharsets.UTF_8.name().equalsIgnoreCase(charset)) {
            return new Utf8Writer(outputStream);
        }
        return new EncodingWriter(outputStream, charset);
    }

    public static WriteThroughWriter newWriter(OutputStream outputStream, Charset charset) throws IOException {
        if (StandardCharsets.ISO_8859_1 == charset) {
            return new Iso88591Writer(outputStream);
        }
        if (StandardCharsets.UTF_8.equals(charset)) {
            return new Utf8Writer(outputStream);
        }
        return new EncodingWriter(outputStream, charset);
    }

    public int getMaxWriteSize() {
        return this._maxWriteSize;
    }

    @Override
    public void close() throws IOException {
        this._out.close();
    }

    @Override
    public void flush() throws IOException {
        this._out.flush();
    }

    @Override
    public abstract WriteThroughWriter append(CharSequence var1) throws IOException;

    @Override
    public void write(String string, int offset, int length) throws IOException {
        while (length > this._maxWriteSize) {
            this.append(WriteThroughWriter.subSequence(string, offset, this._maxWriteSize));
            offset += this._maxWriteSize;
            length -= this._maxWriteSize;
        }
        this.append(WriteThroughWriter.subSequence(string, offset, length));
    }

    @Override
    public void write(char[] chars, int offset, int length) throws IOException {
        while (length > this._maxWriteSize) {
            this.append(WriteThroughWriter.subSequence(chars, offset, this._maxWriteSize));
            offset += this._maxWriteSize;
            length -= this._maxWriteSize;
        }
        this.append(WriteThroughWriter.subSequence(chars, offset, length));
    }

    static CharSequence subSequence(final String string, final int offset, final int length) {
        Objects.requireNonNull(string);
        if (offset == 0 && string.length() == length) {
            return string;
        }
        if (length == 0) {
            return "";
        }
        int end = offset + length;
        if (offset < 0 || offset > end || end > string.length()) {
            throw new IndexOutOfBoundsException("offset and/or length out of range");
        }
        return new CharSequence(){

            @Override
            public int length() {
                return length;
            }

            @Override
            public char charAt(int index) {
                return string.charAt(offset + index);
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                return WriteThroughWriter.subSequence(string, offset + start, end - start);
            }

            @Override
            public String toString() {
                return string.substring(offset, offset + length);
            }
        };
    }

    static CharSequence subSequence(char[] chars, int offset, int length) {
        if (length == 0) {
            return "";
        }
        return CharBuffer.wrap(chars, offset, length);
    }

    private static class Iso88591Writer
    extends WriteThroughWriter {
        private Iso88591Writer(OutputStream out) {
            super(out);
        }

        @Override
        public WriteThroughWriter append(CharSequence charSequence) throws IOException {
            assert (charSequence.length() <= this.getMaxWriteSize());
            if (charSequence.length() == 1) {
                int c = charSequence.charAt(0);
                this._out.write(c < 256 ? c : 63);
                return this;
            }
            this._bytes.reset();
            int bytes = 0;
            byte[] buffer = this._bytes.getBuf();
            int length = charSequence.length();
            for (int offset = 0; offset < length; ++offset) {
                int c = charSequence.charAt(offset);
                buffer[bytes++] = (byte)(c < 256 ? c : 63);
            }
            if (bytes >= 0) {
                this._bytes.setCount(bytes);
            }
            this._bytes.writeTo(this._out);
            return this;
        }
    }

    private static class Utf8Writer
    extends WriteThroughWriter {
        int _surrogate = 0;

        private Utf8Writer(OutputStream out) {
            super(out);
        }

        @Override
        public WriteThroughWriter append(CharSequence charSequence) throws IOException {
            assert (charSequence.length() <= this.getMaxWriteSize());
            int length = charSequence.length();
            int offset = 0;
            while (length > 0) {
                this._bytes.reset();
                int chars = Math.min(length, this.getMaxWriteSize());
                byte[] buffer = this._bytes.getBuf();
                int bytes = this._bytes.getCount();
                if (bytes + chars > buffer.length) {
                    chars = buffer.length - bytes;
                }
                for (int i2 = 0; i2 < chars; ++i2) {
                    int code = charSequence.charAt(offset + i2);
                    if (this._surrogate == 0) {
                        if (Character.isHighSurrogate((char)code)) {
                            this._surrogate = code;
                            continue;
                        }
                    } else if (Character.isLowSurrogate((char)code)) {
                        code = Character.toCodePoint((char)this._surrogate, (char)code);
                    } else {
                        code = this._surrogate;
                        this._surrogate = 0;
                        --i2;
                    }
                    if ((code & 0xFFFFFF80) == 0) {
                        if (bytes >= buffer.length) {
                            chars = i2;
                            break;
                        }
                        buffer[bytes++] = (byte)code;
                        continue;
                    }
                    if ((code & 0xFFFFF800) == 0) {
                        if (bytes + 2 > buffer.length) {
                            chars = i2;
                            break;
                        }
                        buffer[bytes++] = (byte)(0xC0 | code >> 6);
                        buffer[bytes++] = (byte)(0x80 | code & 0x3F);
                    } else if ((code & 0xFFFF0000) == 0) {
                        if (bytes + 3 > buffer.length) {
                            chars = i2;
                            break;
                        }
                        buffer[bytes++] = (byte)(0xE0 | code >> 12);
                        buffer[bytes++] = (byte)(0x80 | code >> 6 & 0x3F);
                        buffer[bytes++] = (byte)(0x80 | code & 0x3F);
                    } else if ((code & 0xFF200000) == 0) {
                        if (bytes + 4 > buffer.length) {
                            chars = i2;
                            break;
                        }
                        buffer[bytes++] = (byte)(0xF0 | code >> 18);
                        buffer[bytes++] = (byte)(0x80 | code >> 12 & 0x3F);
                        buffer[bytes++] = (byte)(0x80 | code >> 6 & 0x3F);
                        buffer[bytes++] = (byte)(0x80 | code & 0x3F);
                    } else if ((code & 0xF4000000) == 0) {
                        if (bytes + 5 > buffer.length) {
                            chars = i2;
                            break;
                        }
                        buffer[bytes++] = (byte)(0xF8 | code >> 24);
                        buffer[bytes++] = (byte)(0x80 | code >> 18 & 0x3F);
                        buffer[bytes++] = (byte)(0x80 | code >> 12 & 0x3F);
                        buffer[bytes++] = (byte)(0x80 | code >> 6 & 0x3F);
                        buffer[bytes++] = (byte)(0x80 | code & 0x3F);
                    } else if ((code & Integer.MIN_VALUE) == 0) {
                        if (bytes + 6 > buffer.length) {
                            chars = i2;
                            break;
                        }
                        buffer[bytes++] = (byte)(0xFC | code >> 30);
                        buffer[bytes++] = (byte)(0x80 | code >> 24 & 0x3F);
                        buffer[bytes++] = (byte)(0x80 | code >> 18 & 0x3F);
                        buffer[bytes++] = (byte)(0x80 | code >> 12 & 0x3F);
                        buffer[bytes++] = (byte)(0x80 | code >> 6 & 0x3F);
                        buffer[bytes++] = (byte)(0x80 | code & 0x3F);
                    } else {
                        buffer[bytes++] = 63;
                    }
                    this._surrogate = 0;
                    if (bytes != buffer.length) continue;
                    chars = i2 + 1;
                    break;
                }
                this._bytes.setCount(bytes);
                this._bytes.writeTo(this._out);
                length -= chars;
                offset += chars;
            }
            return this;
        }
    }

    private static class EncodingWriter
    extends WriteThroughWriter {
        final Writer _converter;

        public EncodingWriter(OutputStream out, String encoding) throws IOException {
            super(out);
            this._converter = new OutputStreamWriter((OutputStream)this._bytes, encoding);
        }

        public EncodingWriter(OutputStream out, Charset charset) throws IOException {
            super(out);
            this._converter = new OutputStreamWriter((OutputStream)this._bytes, charset);
        }

        @Override
        public WriteThroughWriter append(CharSequence charSequence) throws IOException {
            assert (charSequence.length() <= this.getMaxWriteSize());
            this._bytes.reset();
            this._converter.append(charSequence);
            this._converter.flush();
            this._bytes.writeTo(this._out);
            return this;
        }
    }
}

