/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.transport.internal;

import java.nio.ByteBuffer;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpRequestException;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.transport.HttpExchange;
import org.eclipse.jetty.client.transport.HttpRequest;
import org.eclipse.jetty.client.transport.HttpSender;
import org.eclipse.jetty.client.transport.internal.HttpChannelOverHTTP;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSenderOverHTTP
extends HttpSender {
    private static final Logger LOG = LoggerFactory.getLogger(HttpSenderOverHTTP.class);
    private final IteratingCallback headersCallback = new HeadersCallback();
    private final IteratingCallback contentCallback = new ContentCallback();
    private final HttpGenerator generator = new HttpGenerator();
    private MetaData.Request metaData;
    private ByteBuffer contentByteBuffer;
    private boolean lastContent;
    private Callback callback;
    private boolean shutdown;

    public HttpSenderOverHTTP(HttpChannelOverHTTP channel) {
        super(channel);
    }

    @Override
    public HttpChannelOverHTTP getHttpChannel() {
        return (HttpChannelOverHTTP)super.getHttpChannel();
    }

    @Override
    protected void sendHeaders(HttpExchange exchange2, ByteBuffer contentBuffer, boolean lastContent, Callback callback) {
        try {
            this.contentByteBuffer = contentBuffer;
            this.lastContent = lastContent;
            this.callback = callback;
            HttpRequest request = exchange2.getRequest();
            Request.Content requestContent = request.getBody();
            long contentLength = requestContent == null ? -1L : requestContent.getLength();
            Object path = request.getPath();
            String query = request.getQuery();
            if (query != null) {
                path = (String)path + "?" + query;
            }
            this.metaData = new MetaData.Request(request.getMethod(), HttpURI.from((String)path), request.getVersion(), request.getHeaders(), contentLength, request.getTrailersSupplier());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending headers with content {} last={} for {}", BufferUtil.toDetailString(contentBuffer), lastContent, exchange2.getRequest());
            }
            this.headersCallback.iterate();
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to send headers on exchange {}", (Object)exchange2, (Object)x);
            }
            callback.failed(x);
        }
    }

    @Override
    protected void sendContent(HttpExchange exchange2, ByteBuffer contentBuffer, boolean lastContent, Callback callback) {
        try {
            this.contentByteBuffer = contentBuffer;
            this.lastContent = lastContent;
            this.callback = callback;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending content {} last={} for {}", BufferUtil.toDetailString(contentBuffer), lastContent, exchange2.getRequest());
            }
            this.contentCallback.iterate();
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to send content on {}", (Object)exchange2, (Object)x);
            }
            callback.failed(x);
        }
    }

    @Override
    protected void reset() {
        this.headersCallback.reset();
        this.contentCallback.reset();
        this.generator.reset();
        super.reset();
    }

    @Override
    protected void dispose() {
        this.generator.abort();
        super.dispose();
        this.shutdownOutput();
    }

    private void shutdownOutput() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request shutdown output {}", (Object)this.getHttpExchange().getRequest());
        }
        this.shutdown = true;
    }

    protected boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public String toString() {
        return String.format("%s[%s]", super.toString(), this.generator);
    }

    private class HeadersCallback
    extends IteratingCallback {
        private RetainableByteBuffer headerBuffer;
        private RetainableByteBuffer chunkBuffer;
        private boolean generated;

        private HeadersCallback() {
            super(false);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected IteratingCallback.Action process() throws Exception {
            HttpGenerator.Result result;
            HttpClient httpClient = HttpSenderOverHTTP.this.getHttpChannel().getHttpDestination().getHttpClient();
            HttpExchange exchange2 = HttpSenderOverHTTP.this.getHttpExchange();
            ByteBufferPool bufferPool = httpClient.getByteBufferPool();
            boolean useDirectByteBuffers = httpClient.isUseOutputDirectByteBuffers();
            block10: while (true) {
                ByteBuffer headerByteBuffer = this.headerBuffer == null ? null : this.headerBuffer.getByteBuffer();
                ByteBuffer chunkByteBuffer = this.chunkBuffer == null ? null : this.chunkBuffer.getByteBuffer();
                result = HttpSenderOverHTTP.this.generator.generateRequest(HttpSenderOverHTTP.this.metaData, headerByteBuffer, chunkByteBuffer, HttpSenderOverHTTP.this.contentByteBuffer, HttpSenderOverHTTP.this.lastContent);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Generated headers ({} bytes), chunk ({} bytes), content ({} bytes) - {}/{} for {}", new Object[]{headerByteBuffer == null ? -1 : headerByteBuffer.remaining(), chunkByteBuffer == null ? -1 : chunkByteBuffer.remaining(), HttpSenderOverHTTP.this.contentByteBuffer == null ? -1 : HttpSenderOverHTTP.this.contentByteBuffer.remaining(), result, HttpSenderOverHTTP.this.generator, exchange2.getRequest()});
                }
                switch (result) {
                    case NEED_HEADER: {
                        this.headerBuffer = bufferPool.acquire(httpClient.getRequestBufferSize(), useDirectByteBuffers);
                        continue block10;
                    }
                    case HEADER_OVERFLOW: {
                        this.headerBuffer.release();
                        this.headerBuffer = null;
                        throw new IllegalArgumentException("Request header too large");
                    }
                    case NEED_CHUNK: {
                        this.chunkBuffer = bufferPool.acquire(12, useDirectByteBuffers);
                        continue block10;
                    }
                    case NEED_CHUNK_TRAILER: {
                        this.chunkBuffer = bufferPool.acquire(httpClient.getRequestBufferSize(), useDirectByteBuffers);
                        continue block10;
                    }
                    case FLUSH: {
                        EndPoint endPoint = HttpSenderOverHTTP.this.getHttpChannel().getHttpConnection().getEndPoint();
                        if (headerByteBuffer == null) {
                            headerByteBuffer = BufferUtil.EMPTY_BUFFER;
                        }
                        if (chunkByteBuffer == null) {
                            chunkByteBuffer = BufferUtil.EMPTY_BUFFER;
                        }
                        if (HttpSenderOverHTTP.this.contentByteBuffer == null) {
                            HttpSenderOverHTTP.this.contentByteBuffer = BufferUtil.EMPTY_BUFFER;
                        }
                        long bytes = headerByteBuffer.remaining() + chunkByteBuffer.remaining() + HttpSenderOverHTTP.this.contentByteBuffer.remaining();
                        HttpSenderOverHTTP.this.getHttpChannel().getHttpConnection().addBytesOut(bytes);
                        endPoint.write((Callback)this, headerByteBuffer, chunkByteBuffer, HttpSenderOverHTTP.this.contentByteBuffer);
                        this.generated = true;
                        return IteratingCallback.Action.SCHEDULED;
                    }
                    case SHUTDOWN_OUT: {
                        HttpSenderOverHTTP.this.shutdownOutput();
                        return IteratingCallback.Action.SUCCEEDED;
                    }
                    case CONTINUE: {
                        if (this.generated) return IteratingCallback.Action.SUCCEEDED;
                        continue block10;
                    }
                    case DONE: {
                        if (!this.generated) throw new HttpRequestException("Could not generate headers", exchange2.getRequest());
                        return IteratingCallback.Action.SUCCEEDED;
                    }
                }
                break;
            }
            throw new IllegalStateException(result.toString());
        }

        @Override
        public void succeeded() {
            this.release();
            super.succeeded();
        }

        @Override
        public void failed(Throwable x) {
            this.release();
            super.failed(x);
        }

        @Override
        protected void onCompleteSuccess() {
            super.onCompleteSuccess();
            HttpSenderOverHTTP.this.callback.succeeded();
        }

        @Override
        protected void onCompleteFailure(Throwable cause) {
            super.onCompleteFailure(cause);
            HttpSenderOverHTTP.this.callback.failed(cause);
        }

        private void release() {
            if (this.headerBuffer != null) {
                this.headerBuffer.release();
            }
            this.headerBuffer = null;
            if (this.chunkBuffer != null) {
                this.chunkBuffer.release();
            }
            this.chunkBuffer = null;
            HttpSenderOverHTTP.this.contentByteBuffer = null;
        }
    }

    private class ContentCallback
    extends IteratingCallback {
        private RetainableByteBuffer chunkBuffer;

        public ContentCallback() {
            super(false);
        }

        @Override
        protected IteratingCallback.Action process() throws Exception {
            HttpGenerator.Result result;
            HttpClient httpClient = HttpSenderOverHTTP.this.getHttpChannel().getHttpDestination().getHttpClient();
            ByteBufferPool bufferPool = httpClient.getByteBufferPool();
            boolean useDirectByteBuffers = httpClient.isUseOutputDirectByteBuffers();
            block8: while (true) {
                ByteBuffer chunkByteBuffer = this.chunkBuffer == null ? null : this.chunkBuffer.getByteBuffer();
                result = HttpSenderOverHTTP.this.generator.generateRequest(null, null, chunkByteBuffer, HttpSenderOverHTTP.this.contentByteBuffer, HttpSenderOverHTTP.this.lastContent);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Generated content ({} bytes, last={}) - {}/{}", new Object[]{HttpSenderOverHTTP.this.contentByteBuffer == null ? -1 : HttpSenderOverHTTP.this.contentByteBuffer.remaining(), HttpSenderOverHTTP.this.lastContent, result, HttpSenderOverHTTP.this.generator});
                }
                switch (result) {
                    case NEED_CHUNK: {
                        this.chunkBuffer = bufferPool.acquire(12, useDirectByteBuffers);
                        continue block8;
                    }
                    case NEED_CHUNK_TRAILER: {
                        this.chunkBuffer = bufferPool.acquire(httpClient.getRequestBufferSize(), useDirectByteBuffers);
                        continue block8;
                    }
                    case FLUSH: {
                        EndPoint endPoint = HttpSenderOverHTTP.this.getHttpChannel().getHttpConnection().getEndPoint();
                        if (chunkByteBuffer != null) {
                            endPoint.write((Callback)this, chunkByteBuffer, HttpSenderOverHTTP.this.contentByteBuffer);
                        } else {
                            endPoint.write((Callback)this, HttpSenderOverHTTP.this.contentByteBuffer);
                        }
                        return IteratingCallback.Action.SCHEDULED;
                    }
                    case SHUTDOWN_OUT: {
                        HttpSenderOverHTTP.this.shutdownOutput();
                        continue block8;
                    }
                    case CONTINUE: {
                        continue block8;
                    }
                    case DONE: {
                        this.release();
                        HttpSenderOverHTTP.this.callback.succeeded();
                        return IteratingCallback.Action.IDLE;
                    }
                }
                break;
            }
            throw new IllegalStateException(result.toString());
        }

        @Override
        protected void onCompleteFailure(Throwable cause) {
            this.release();
            HttpSenderOverHTTP.this.callback.failed(cause);
        }

        private void release() {
            if (this.chunkBuffer != null) {
                this.chunkBuffer.release();
            }
            this.chunkBuffer = null;
            HttpSenderOverHTTP.this.contentByteBuffer = null;
        }
    }
}

