/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.transport;

import java.net.URI;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.ContentDecoder;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.client.Result;
import org.eclipse.jetty.client.transport.HttpChannel;
import org.eclipse.jetty.client.transport.HttpConversation;
import org.eclipse.jetty.client.transport.HttpDestination;
import org.eclipse.jetty.client.transport.HttpExchange;
import org.eclipse.jetty.client.transport.HttpResponse;
import org.eclipse.jetty.client.transport.ResponseListeners;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.QuotedCSV;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.io.content.ContentSourceTransformer;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.component.Destroyable;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.SerializedInvoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpReceiver {
    private static final Logger LOG = LoggerFactory.getLogger(HttpReceiver.class);
    private final SerializedInvoker invoker = new SerializedInvoker();
    private final HttpChannel channel;
    private ResponseState responseState = ResponseState.IDLE;
    private NotifiableContentSource contentSource;
    private Throwable failure;

    protected HttpReceiver(HttpChannel channel) {
        this.channel = channel;
    }

    protected abstract Content.Chunk read(boolean var1);

    protected abstract void onInterim();

    protected abstract void failAndClose(Throwable var1);

    protected HttpChannel getHttpChannel() {
        return this.channel;
    }

    protected HttpExchange getHttpExchange() {
        return this.channel.getHttpExchange();
    }

    protected HttpDestination getHttpDestination() {
        return this.channel.getHttpDestination();
    }

    public boolean isFailed() {
        return this.responseState == ResponseState.FAILURE;
    }

    protected boolean hasContent() {
        return this.contentSource != null;
    }

    protected void responseBegin(HttpExchange exchange2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invoking responseBegin for {} on {}", (Object)exchange2, (Object)this);
        }
        this.invoker.run(() -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing responseBegin for {} on {}", (Object)exchange2, (Object)this);
            }
            if (exchange2.isResponseCompleteOrTerminated()) {
                return;
            }
            this.responseState = ResponseState.BEGIN;
            HttpResponse response = exchange2.getResponse();
            HttpConversation conversation = exchange2.getConversation();
            HttpClient client = this.getHttpDestination().getHttpClient();
            ProtocolHandler protocolHandler = client.findProtocolHandler(exchange2.getRequest(), response);
            Response.Listener handlerListener = null;
            if (protocolHandler != null) {
                handlerListener = protocolHandler.getResponseListener();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Response {} found protocol handler {}", (Object)response, (Object)protocolHandler);
                }
            }
            conversation.updateResponseListeners(handlerListener);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response begin {}", (Object)response);
            }
            conversation.getResponseListeners().notifyBegin(response);
        });
    }

    protected void responseHeader(HttpExchange exchange2, HttpField field) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invoking responseHeader for {} on {}", (Object)field, (Object)this);
        }
        this.invoker.run(() -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing responseHeader on {}", (Object)this);
            }
            if (exchange2.isResponseCompleteOrTerminated()) {
                return;
            }
            this.responseState = ResponseState.HEADER;
            HttpResponse response = exchange2.getResponse();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Notifying header {}", (Object)field);
            }
            boolean process = exchange2.getConversation().getResponseListeners().notifyHeader(response, field);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Header {} notified, {}processing needed", (Object)field, (Object)(process ? "" : "no "));
            }
            if (process) {
                response.addHeader(field);
                HttpHeader fieldHeader = field.getHeader();
                if (fieldHeader != null) {
                    switch (fieldHeader) {
                        case SET_COOKIE: 
                        case SET_COOKIE2: {
                            URI uri = exchange2.getRequest().getURI();
                            if (uri == null) break;
                            this.storeCookie(uri, field);
                        }
                    }
                }
            }
        });
    }

    protected void storeCookie(URI uri, HttpField field) {
        this.getHttpDestination().getHttpClient().putCookie(uri, field);
    }

    protected void responseHeaders(HttpExchange exchange2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invoking responseHeaders on {}", (Object)this);
        }
        this.invoker.run(() -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing responseHeaders on {}", (Object)this);
            }
            if (exchange2.isResponseCompleteOrTerminated()) {
                return;
            }
            this.responseState = ResponseState.HEADERS;
            HttpResponse response = exchange2.getResponse();
            HttpFields responseHeaders = response.getHeaders();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response headers {}{}{}", response, System.lineSeparator(), responseHeaders.toString().trim());
            }
            ContentDecoder decoder = null;
            if (!HttpMethod.HEAD.is(exchange2.getRequest().getMethod())) {
                int comma;
                String contentEncoding = responseHeaders.getLast(HttpHeader.CONTENT_ENCODING);
                if (contentEncoding != null && (comma = contentEncoding.indexOf(",")) > 0) {
                    List<String> values = new QuotedCSV(false, contentEncoding).getValues();
                    contentEncoding = values.get(values.size() - 1);
                }
                for (ContentDecoder.Factory factory : this.getHttpDestination().getHttpClient().getContentDecoderFactories()) {
                    if (!factory.getEncoding().equalsIgnoreCase(contentEncoding)) continue;
                    decoder = factory.newContentDecoder();
                    decoder.beforeDecoding(response);
                    break;
                }
            }
            ResponseListeners responseListeners = exchange2.getConversation().getResponseListeners();
            responseListeners.notifyHeaders(response);
            if (exchange2.isResponseCompleteOrTerminated()) {
                return;
            }
            if (HttpStatus.isInterim(response.getStatus())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Interim response status {}, succeeding", (Object)response.getStatus());
                }
                this.responseSuccess(exchange2, this::onInterim);
                return;
            }
            this.responseState = ResponseState.CONTENT;
            if (this.contentSource != null) {
                throw new IllegalStateException();
            }
            this.contentSource = new ContentSource();
            if (decoder != null) {
                this.contentSource = new DecodingContentSource(this.contentSource, this.invoker, decoder, response);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response content {} {}", (Object)response, (Object)this.contentSource);
            }
            responseListeners.notifyContentSource(response, this.contentSource);
        });
    }

    protected void responseContentAvailable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response content available on {}", (Object)this);
        }
        this.contentSource.onDataAvailable();
    }

    protected void responseSuccess(HttpExchange exchange2, Runnable afterSuccessTask) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invoking responseSuccess on {}", (Object)this);
        }
        if (!exchange2.responseComplete(null)) {
            return;
        }
        this.invoker.run(() -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing responseSuccess on {}", (Object)this);
            }
            this.responseState = ResponseState.IDLE;
            this.reset();
            HttpResponse response = exchange2.getResponse();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response success {}", (Object)response);
            }
            exchange2.getConversation().getResponseListeners().notifySuccess(response);
            if (HttpStatus.isInterim(exchange2.getResponse().getStatus())) {
                return;
            }
            this.terminateResponse(exchange2);
        }, afterSuccessTask);
    }

    protected void responseFailure(Throwable failure, Promise<Boolean> promise) {
        HttpExchange exchange2;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Failing with {} on {}", (Object)failure, (Object)this);
        }
        if ((exchange2 = this.getHttpExchange()) != null && exchange2.responseComplete(failure)) {
            this.abort(exchange2, failure, promise);
        } else {
            promise.succeeded(false);
        }
    }

    private void terminateResponse(HttpExchange exchange2) {
        Result result = exchange2.terminateResponse();
        this.terminateResponse(exchange2, result);
    }

    private void terminateResponse(HttpExchange exchange2, Result result) {
        HttpResponse response = exchange2.getResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response complete {}, result: {}", (Object)response, (Object)result);
        }
        if (result != null) {
            result = this.channel.exchangeTerminating(exchange2, result);
            boolean ordered = this.getHttpDestination().getHttpClient().isStrictEventOrdering();
            if (!ordered) {
                this.channel.exchangeTerminated(exchange2, result);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request/Response {}: {}", (Object)(this.failure == null ? "succeeded" : "failed"), (Object)result);
            }
            exchange2.getConversation().getResponseListeners().notifyComplete(result);
            if (ordered) {
                this.channel.exchangeTerminated(exchange2, result);
            }
        }
    }

    protected void reset() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resetting {}", (Object)this);
        }
        this.cleanup();
    }

    protected void dispose() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Disposing {}", (Object)this);
        }
        this.cleanup();
    }

    private void cleanup() {
        if (this.contentSource != null) {
            this.contentSource.destroy();
        }
        this.contentSource = null;
    }

    public void abort(HttpExchange exchange2, Throwable failure, Promise<Boolean> promise) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invoking abort with {} on {}", (Object)failure, (Object)this);
        }
        if (!exchange2.isResponseCompleteOrTerminated()) {
            throw new IllegalStateException();
        }
        this.invoker.run(() -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing abort with {} on {}", (Object)failure, (Object)this);
            }
            if (this.responseState == ResponseState.FAILURE) {
                promise.succeeded(false);
                return;
            }
            this.responseState = ResponseState.FAILURE;
            this.failure = failure;
            if (this.contentSource != null) {
                this.contentSource.error(failure);
            }
            this.dispose();
            HttpResponse response = exchange2.getResponse();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response abort {} {} on {}", response, exchange2, this.getHttpChannel(), failure);
            }
            exchange2.getConversation().getResponseListeners().notifyFailure(response, failure);
            this.terminateResponse(exchange2);
            promise.succeeded(true);
        });
    }

    public String toString() {
        return String.format("%s@%x(ex=%s,rsp=%s,failure=%s)", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this.getHttpExchange(), this.responseState, this.failure});
    }

    private static enum ResponseState {
        IDLE,
        BEGIN,
        HEADER,
        HEADERS,
        CONTENT,
        FAILURE;

    }

    private static interface NotifiableContentSource
    extends Content.Source,
    Destroyable {
        public boolean error(Throwable var1);

        public void onDataAvailable();

        @Override
        default public void destroy() {
        }
    }

    private class ContentSource
    implements NotifiableContentSource {
        private static final Logger LOG = LoggerFactory.getLogger(ContentSource.class);
        private final AtomicReference<Runnable> demandCallbackRef = new AtomicReference();
        private final AutoLock lock = new AutoLock();
        private final Runnable processDemand = this::processDemand;
        private Content.Chunk currentChunk;

        private ContentSource() {
        }

        @Override
        public Content.Chunk read() {
            Content.Chunk current;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reading from {}", (Object)this);
            }
            try (AutoLock ignored = this.lock.lock();){
                current = this.currentChunk;
                this.currentChunk = Content.Chunk.next(current);
                if (current != null) {
                    Content.Chunk chunk = current;
                    return chunk;
                }
            }
            current = HttpReceiver.this.read(false);
            ignored = this.lock.lock();
            try {
                if (this.currentChunk != null) {
                    if (current != null) {
                        current.release();
                    }
                    Content.Chunk chunk = this.currentChunk;
                    return chunk;
                }
                this.currentChunk = Content.Chunk.next(current);
                Content.Chunk chunk = current;
                return chunk;
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
        }

        @Override
        public void onDataAvailable() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("onDataAvailable on {}", (Object)this);
            }
            this.invokeDemandCallback(true);
        }

        @Override
        public void demand(Runnable demandCallback) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registering demand on {}", (Object)this);
            }
            if (demandCallback == null) {
                throw new IllegalArgumentException();
            }
            if (!this.demandCallbackRef.compareAndSet(null, demandCallback)) {
                throw new IllegalStateException();
            }
            HttpReceiver.this.invoker.run(this.processDemand);
        }

        private void processDemand() {
            Content.Chunk current;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing demand on {}", (Object)this);
            }
            try (AutoLock ignored = this.lock.lock();){
                current = this.currentChunk;
            }
            if (current == null) {
                current = HttpReceiver.this.read(true);
                if (current == null) {
                    return;
                }
                ignored = this.lock.lock();
                try {
                    if (this.currentChunk != null) {
                        current.release();
                        return;
                    }
                    this.currentChunk = current;
                }
                finally {
                    if (ignored != null) {
                        ignored.close();
                    }
                }
            }
            this.invokeDemandCallback(false);
        }

        private void invokeDemandCallback(boolean invoke) {
            Runnable demandCallback = this.demandCallbackRef.getAndSet(null);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Invoking demand callback on {}", (Object)this);
            }
            if (demandCallback != null) {
                try {
                    if (invoke) {
                        HttpReceiver.this.invoker.run(demandCallback);
                    } else {
                        demandCallback.run();
                    }
                }
                catch (Throwable x) {
                    this.fail(x);
                }
            }
        }

        @Override
        public void fail(Throwable failure) {
            boolean failed;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failing {}", (Object)this);
            }
            if (failed = this.error(failure)) {
                HttpReceiver.this.failAndClose(failure);
            }
            this.invokeDemandCallback(true);
        }

        @Override
        public boolean error(Throwable failure) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Erroring {}", (Object)this);
            }
            try (AutoLock ignored = this.lock.lock();){
                if (Content.Chunk.isFailure(this.currentChunk)) {
                    Throwable cause = this.currentChunk.getFailure();
                    if (!this.currentChunk.isLast()) {
                        this.currentChunk = Content.Chunk.from(cause, true);
                    }
                    ExceptionUtil.addSuppressedIfNotAssociated(cause, failure);
                    boolean bl = false;
                    return bl;
                }
                if (this.currentChunk != null) {
                    this.currentChunk.release();
                }
                this.currentChunk = Content.Chunk.from(failure);
            }
            return true;
        }

        private Content.Chunk chunk() {
            try (AutoLock ignored = this.lock.lock();){
                Content.Chunk chunk = this.currentChunk;
                return chunk;
            }
        }

        public String toString() {
            return String.format("%s@%x{c=%s,d=%s}", this.getClass().getSimpleName(), this.hashCode(), this.chunk(), this.demandCallbackRef);
        }
    }

    private static class DecodingContentSource
    extends ContentSourceTransformer
    implements NotifiableContentSource {
        private static final Logger LOG = LoggerFactory.getLogger(DecodingContentSource.class);
        private final ContentDecoder _decoder;
        private final Response _response;
        private volatile Content.Chunk _chunk;

        private DecodingContentSource(NotifiableContentSource rawSource, SerializedInvoker invoker, ContentDecoder decoder, Response response) {
            super(rawSource, invoker);
            this._decoder = decoder;
            this._response = response;
        }

        @Override
        protected NotifiableContentSource getContentSource() {
            return (NotifiableContentSource)super.getContentSource();
        }

        @Override
        public void onDataAvailable() {
            this.getContentSource().onDataAvailable();
        }

        @Override
        protected Content.Chunk transform(Content.Chunk inputChunk) {
            while (true) {
                boolean retain;
                boolean bl = retain = this._chunk == null;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("input: {}, chunk: {}, retain? {}", inputChunk, this._chunk, retain);
                }
                if (this._chunk == null) {
                    this._chunk = inputChunk;
                }
                if (this._chunk == null) {
                    return null;
                }
                if (Content.Chunk.isFailure(this._chunk)) {
                    Content.Chunk failure = this._chunk;
                    this._chunk = Content.Chunk.next(failure);
                    return failure;
                }
                if (retain) {
                    this._chunk.retain();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("decoding: {}", (Object)this._chunk);
                }
                RetainableByteBuffer decodedBuffer = this._decoder.decode(this._chunk.getByteBuffer());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("decoded: {}", (Object)decodedBuffer);
                }
                if (decodedBuffer != null && decodedBuffer.hasRemaining()) {
                    if (decodedBuffer.canRetain()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("returning decoded content");
                        }
                        return Content.Chunk.asChunk(decodedBuffer.getByteBuffer(), false, decodedBuffer);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("returning non-retainable decoded content");
                    }
                    return Content.Chunk.from(decodedBuffer.getByteBuffer(), false);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("decoding produced no content");
                }
                if (decodedBuffer != null) {
                    decodedBuffer.release();
                }
                if (!this._chunk.hasRemaining()) {
                    Content.Chunk result;
                    Content.Chunk chunk = result = this._chunk.isLast() ? Content.Chunk.EOF : null;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Could not decode more from this chunk, releasing it, r={}", (Object)result);
                    }
                    this._chunk.release();
                    this._chunk = null;
                    return result;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("retrying transformation");
            }
        }

        @Override
        public boolean error(Throwable failure) {
            if (this._chunk != null) {
                this._chunk.release();
            }
            this._chunk = null;
            return this.getContentSource().error(failure);
        }

        @Override
        public void destroy() {
            this._decoder.afterDecoding(this._response);
            this.getContentSource().destroy();
        }
    }
}

