/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.transport;

import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.client.transport.HttpExchange;
import org.eclipse.jetty.client.transport.ResponseListeners;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.Promise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConversation
extends Attributes.Lazy {
    private static final Logger LOG = LoggerFactory.getLogger(HttpConversation.class);
    private final Deque<HttpExchange> exchanges = new ConcurrentLinkedDeque<HttpExchange>();
    private volatile ResponseListeners listeners;

    public Deque<HttpExchange> getExchanges() {
        return this.exchanges;
    }

    public ResponseListeners getResponseListeners() {
        return this.listeners;
    }

    public void updateResponseListeners(Response.Listener overrideListener) {
        ResponseListeners listeners;
        HttpExchange lastExchange;
        HttpExchange firstExchange = this.exchanges.peekFirst();
        if (firstExchange == (lastExchange = this.exchanges.peekLast())) {
            listeners = overrideListener != null ? new ResponseListeners(overrideListener) : new ResponseListeners(firstExchange.getResponseListeners());
        } else {
            listeners = new ResponseListeners(lastExchange.getResponseListeners());
            if (overrideListener != null) {
                listeners.addListener(overrideListener);
            } else {
                listeners.addResponseListeners(firstExchange.getResponseListeners());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exchanges in conversation {}, override={}, listeners={}", this.exchanges.size(), overrideListener, listeners);
        }
        this.listeners = listeners;
    }

    public long getTimeout() {
        HttpExchange firstExchange = this.exchanges.peekFirst();
        return firstExchange == null ? 0L : firstExchange.getRequest().getTimeout();
    }

    public void abort(Throwable cause, Promise<Boolean> promise) {
        HttpExchange exchange2 = this.exchanges.peekLast();
        if (exchange2 != null) {
            exchange2.abort(cause, promise);
        } else {
            promise.succeeded(false);
        }
    }

    @Override
    public String toString() {
        return String.format("%s[%x]", HttpConversation.class.getSimpleName(), this.hashCode());
    }
}

