/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.retry;

import feign.ExceptionPropagationPolicy;
import java.time.Duration;
import reactivefeign.retry.ReactiveRetryPolicy;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.util.function.Tuples;
import reactor.util.retry.Retry;

public abstract class SimpleReactiveRetryPolicy
implements ReactiveRetryPolicy {
    private final Scheduler scheduler;
    private final ExceptionPropagationPolicy exceptionPropagationPolicy;

    protected SimpleReactiveRetryPolicy(Scheduler scheduler, ExceptionPropagationPolicy exceptionPropagationPolicy) {
        this.scheduler = scheduler;
        this.exceptionPropagationPolicy = exceptionPropagationPolicy;
    }

    @Override
    public ExceptionPropagationPolicy exceptionPropagationPolicy() {
        return this.exceptionPropagationPolicy != null ? this.exceptionPropagationPolicy : ReactiveRetryPolicy.super.exceptionPropagationPolicy();
    }

    public abstract long retryDelay(Throwable var1, int var2);

    @Override
    public Retry retry() {
        return Retry.from(errors -> errors.zipWith(Flux.range(1, this.maxAllowedRetries() + 1), (signal, index) -> {
            long delay = this.retryDelay(signal.failure(), (int)index);
            if (delay >= 0L) {
                return Tuples.of(delay, signal);
            }
            throw Exceptions.propagate(signal.failure());
        }).concatMap(tuple2 -> (Long)tuple2.getT1() > 0L ? Mono.delay(Duration.ofMillis((Long)tuple2.getT1()), this.scheduler).map(time -> ((Retry.RetrySignal)tuple2.getT2()).failure()) : Mono.just(((Retry.RetrySignal)tuple2.getT2()).failure())));
    }
}

