/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.methodhandler;

import feign.MethodMetadata;
import feign.Target;
import feign.Util;
import java.lang.reflect.Method;
import reactivefeign.methodhandler.DefaultMethodHandler;
import reactivefeign.methodhandler.FluxMethodHandler;
import reactivefeign.methodhandler.MethodHandler;
import reactivefeign.methodhandler.MethodHandlerFactory;
import reactivefeign.methodhandler.MonoMethodHandler;
import reactivefeign.methodhandler.PublisherClientMethodHandler;
import reactivefeign.publisher.PublisherClientFactory;
import reactivefeign.utils.FeignUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveMethodHandlerFactory
implements MethodHandlerFactory {
    private final PublisherClientFactory publisherClientFactory;
    private Target target;

    public ReactiveMethodHandlerFactory(PublisherClientFactory publisherClientFactory) {
        this.publisherClientFactory = Util.checkNotNull(publisherClientFactory, "client must not be null", new Object[0]);
    }

    @Override
    public void target(Target target) {
        this.target = target;
        this.publisherClientFactory.target(target);
    }

    @Override
    public MethodHandler create(MethodMetadata metadata) {
        PublisherClientMethodHandler methodHandler = new PublisherClientMethodHandler(this.target, metadata, this.publisherClientFactory.create(metadata));
        if (FeignUtils.isResponsePublisher(metadata.returnType())) {
            return new MonoMethodHandler(methodHandler);
        }
        Class returnPublisherType = FeignUtils.returnPublisherType(metadata);
        if (returnPublisherType == Mono.class) {
            return new MonoMethodHandler(methodHandler);
        }
        if (returnPublisherType == Flux.class) {
            return new FluxMethodHandler(methodHandler);
        }
        throw new IllegalArgumentException("Unknown returnPublisherType: " + returnPublisherType);
    }

    @Override
    public MethodHandler createDefault(Method method) {
        DefaultMethodHandler defaultMethodHandler = new DefaultMethodHandler(method);
        if (method.getReturnType() == Mono.class) {
            return new MonoMethodHandler(defaultMethodHandler);
        }
        if (method.getReturnType() == Flux.class) {
            return new FluxMethodHandler(defaultMethodHandler);
        }
        throw new IllegalArgumentException("Unknown returnPublisherType: " + method.getReturnType());
    }
}

