/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.resource;

import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Hints;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.log.LogFormatUtils;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.MediaTypeFactory;
import org.springframework.http.codec.ResourceHttpMessageWriter;
import org.springframework.http.server.PathContainer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.resource.DefaultResourceResolverChain;
import org.springframework.web.reactive.resource.DefaultResourceTransformerChain;
import org.springframework.web.reactive.resource.HttpResource;
import org.springframework.web.reactive.resource.PathResourceResolver;
import org.springframework.web.reactive.resource.ResourceResolver;
import org.springframework.web.reactive.resource.ResourceResolverChain;
import org.springframework.web.reactive.resource.ResourceTransformer;
import org.springframework.web.reactive.resource.ResourceTransformerChain;
import org.springframework.web.server.MethodNotAllowedException;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebHandler;
import reactor.core.publisher.Mono;

public class ResourceWebHandler
implements WebHandler,
InitializingBean {
    private static final Set<HttpMethod> SUPPORTED_METHODS = Set.of(HttpMethod.GET, HttpMethod.HEAD);
    private static final Log logger = LogFactory.getLog(ResourceWebHandler.class);
    @Nullable
    private ResourceLoader resourceLoader;
    private final List<String> locationValues = new ArrayList<String>(4);
    private final List<Resource> locationResources = new ArrayList<Resource>(4);
    private final List<Resource> locationsToUse = new ArrayList<Resource>(4);
    private final List<ResourceResolver> resourceResolvers = new ArrayList<ResourceResolver>(4);
    private final List<ResourceTransformer> resourceTransformers = new ArrayList<ResourceTransformer>(4);
    @Nullable
    private ResourceResolverChain resolverChain;
    @Nullable
    private ResourceTransformerChain transformerChain;
    @Nullable
    private CacheControl cacheControl;
    @Nullable
    private ResourceHttpMessageWriter resourceHttpMessageWriter;
    @Nullable
    private Map<String, MediaType> mediaTypes;
    private boolean useLastModified = true;
    private boolean optimizeLocations = false;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setLocationValues(List<String> locationValues) {
        Assert.notNull(locationValues, "Location values list must not be null");
        this.locationValues.clear();
        this.locationValues.addAll(locationValues);
    }

    public List<String> getLocationValues() {
        return this.locationValues;
    }

    public void setLocations(@Nullable List<Resource> locations) {
        this.locationResources.clear();
        if (locations != null) {
            this.locationResources.addAll(locations);
        }
    }

    public List<Resource> getLocations() {
        if (this.locationsToUse.isEmpty()) {
            return this.locationResources;
        }
        return this.locationsToUse;
    }

    public void setResourceResolvers(@Nullable List<ResourceResolver> resourceResolvers) {
        this.resourceResolvers.clear();
        if (resourceResolvers != null) {
            this.resourceResolvers.addAll(resourceResolvers);
        }
    }

    public List<ResourceResolver> getResourceResolvers() {
        return this.resourceResolvers;
    }

    public void setResourceTransformers(@Nullable List<ResourceTransformer> resourceTransformers) {
        this.resourceTransformers.clear();
        if (resourceTransformers != null) {
            this.resourceTransformers.addAll(resourceTransformers);
        }
    }

    public List<ResourceTransformer> getResourceTransformers() {
        return this.resourceTransformers;
    }

    public void setResourceHttpMessageWriter(@Nullable ResourceHttpMessageWriter httpMessageWriter) {
        this.resourceHttpMessageWriter = httpMessageWriter;
    }

    @Nullable
    public ResourceHttpMessageWriter getResourceHttpMessageWriter() {
        return this.resourceHttpMessageWriter;
    }

    public void setCacheControl(@Nullable CacheControl cacheControl) {
        this.cacheControl = cacheControl;
    }

    @Nullable
    public CacheControl getCacheControl() {
        return this.cacheControl;
    }

    public void setUseLastModified(boolean useLastModified) {
        this.useLastModified = useLastModified;
    }

    public boolean isUseLastModified() {
        return this.useLastModified;
    }

    public void setOptimizeLocations(boolean optimizeLocations) {
        this.optimizeLocations = optimizeLocations;
    }

    public boolean isOptimizeLocations() {
        return this.optimizeLocations;
    }

    public void setMediaTypes(Map<String, MediaType> mediaTypes) {
        if (this.mediaTypes == null) {
            this.mediaTypes = new HashMap<String, MediaType>(mediaTypes.size());
        }
        mediaTypes.forEach((ext, type) -> this.mediaTypes.put(ext.toLowerCase(Locale.ENGLISH), (MediaType)type));
    }

    public Map<String, MediaType> getMediaTypes() {
        return this.mediaTypes != null ? this.mediaTypes : Collections.emptyMap();
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.resolveResourceLocations();
        if (this.resourceResolvers.isEmpty()) {
            this.resourceResolvers.add(new PathResourceResolver());
        }
        this.initAllowedLocations();
        if (this.getResourceHttpMessageWriter() == null) {
            this.resourceHttpMessageWriter = new ResourceHttpMessageWriter();
        }
        this.resolverChain = new DefaultResourceResolverChain(this.resourceResolvers);
        this.transformerChain = new DefaultResourceTransformerChain(this.resolverChain, this.resourceTransformers);
    }

    private void resolveResourceLocations() {
        List<Resource> result = new ArrayList<Resource>(this.locationResources);
        if (!this.locationValues.isEmpty()) {
            Assert.notNull((Object)this.resourceLoader, "ResourceLoader is required when \"locationValues\" are configured.");
            Assert.isTrue(CollectionUtils.isEmpty(this.locationResources), "Please set either Resource-based \"locations\" or String-based \"locationValues\", but not both.");
            for (String location : this.locationValues) {
                result.add(this.resourceLoader.getResource(location));
            }
        }
        if (this.isOptimizeLocations()) {
            result = result.stream().filter(Resource::exists).toList();
        }
        this.locationsToUse.clear();
        this.locationsToUse.addAll(result);
    }

    protected void initAllowedLocations() {
        if (CollectionUtils.isEmpty(this.getLocations())) {
            return;
        }
        for (int i2 = this.getResourceResolvers().size() - 1; i2 >= 0; --i2) {
            ResourceResolver resourceResolver = this.getResourceResolvers().get(i2);
            if (!(resourceResolver instanceof PathResourceResolver)) continue;
            PathResourceResolver resolver = (PathResourceResolver)resourceResolver;
            if (!ObjectUtils.isEmpty(resolver.getAllowedLocations())) break;
            resolver.setAllowedLocations(this.getLocations().toArray(new Resource[0]));
            break;
        }
    }

    @Override
    public Mono<Void> handle(ServerWebExchange exchange2) {
        return this.getResource(exchange2).switchIfEmpty(Mono.defer(() -> {
            logger.debug(exchange2.getLogPrefix() + "Resource not found");
            return Mono.error(new ResponseStatusException(HttpStatus.NOT_FOUND));
        })).flatMap(resource -> {
            try {
                if (HttpMethod.OPTIONS.equals(exchange2.getRequest().getMethod())) {
                    exchange2.getResponse().getHeaders().add("Allow", "GET,HEAD,OPTIONS");
                    return Mono.empty();
                }
                HttpMethod httpMethod = exchange2.getRequest().getMethod();
                if (!SUPPORTED_METHODS.contains(httpMethod)) {
                    return Mono.error(new MethodNotAllowedException(exchange2.getRequest().getMethod(), SUPPORTED_METHODS));
                }
                if (this.isUseLastModified() && exchange2.checkNotModified(Instant.ofEpochMilli(resource.lastModified()))) {
                    logger.trace(exchange2.getLogPrefix() + "Resource not modified");
                    return Mono.empty();
                }
                CacheControl cacheControl = this.getCacheControl();
                if (cacheControl != null) {
                    exchange2.getResponse().getHeaders().setCacheControl(cacheControl);
                }
                MediaType mediaType = this.getMediaType((Resource)resource);
                this.setHeaders(exchange2, (Resource)resource, mediaType);
                ResourceHttpMessageWriter writer = this.getResourceHttpMessageWriter();
                Assert.state(writer != null, "No ResourceHttpMessageWriter");
                if (HttpMethod.HEAD == httpMethod) {
                    writer.addHeaders(exchange2.getResponse(), (Resource)resource, mediaType, Hints.from(Hints.LOG_PREFIX_HINT, exchange2.getLogPrefix()));
                    return exchange2.getResponse().setComplete();
                }
                return writer.write((Publisher<? extends Resource>)Mono.just(resource), (ResolvableType)null, ResolvableType.forClass(Resource.class), mediaType, exchange2.getRequest(), exchange2.getResponse(), Hints.from(Hints.LOG_PREFIX_HINT, exchange2.getLogPrefix()));
            }
            catch (IOException ex) {
                return Mono.error(ex);
            }
        });
    }

    protected Mono<Resource> getResource(ServerWebExchange exchange2) {
        String name = HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE;
        PathContainer pathWithinHandler = (PathContainer)exchange2.getRequiredAttribute(name);
        String path = this.processPath(pathWithinHandler.value());
        if (!StringUtils.hasText(path) || this.isInvalidPath(path)) {
            return Mono.empty();
        }
        if (this.isInvalidEncodedPath(path)) {
            return Mono.empty();
        }
        Assert.state(this.resolverChain != null, "ResourceResolverChain not initialized");
        Assert.state(this.transformerChain != null, "ResourceTransformerChain not initialized");
        return this.resolverChain.resolveResource(exchange2, path, this.getLocations()).flatMap(resource -> this.transformerChain.transform(exchange2, (Resource)resource));
    }

    protected String processPath(String path) {
        path = StringUtils.replace(path, "\\", "/");
        path = this.cleanDuplicateSlashes(path);
        return this.cleanLeadingSlash(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String cleanDuplicateSlashes(String path) {
        StringBuilder sb = null;
        char prev = '\u0000';
        for (int i2 = 0; i2 < path.length(); ++i2) {
            char curr = path.charAt(i2);
            try {
                if (curr == '/' && prev == '/') {
                    if (sb != null) continue;
                    sb = new StringBuilder(path.substring(0, i2));
                    continue;
                }
                if (sb == null) continue;
                sb.append(path.charAt(i2));
                continue;
            }
            finally {
                prev = curr;
            }
        }
        return sb != null ? sb.toString() : path;
    }

    private String cleanLeadingSlash(String path) {
        boolean slash = false;
        for (int i2 = 0; i2 < path.length(); ++i2) {
            if (path.charAt(i2) == '/') {
                slash = true;
                continue;
            }
            if (path.charAt(i2) <= ' ' || path.charAt(i2) == '\u007f') continue;
            if (i2 == 0 || i2 == 1 && slash) {
                return path;
            }
            return slash ? "/" + path.substring(i2) : path.substring(i2);
        }
        return slash ? "/" : "";
    }

    private boolean isInvalidEncodedPath(String path) {
        if (path.contains("%")) {
            try {
                String decodedPath = URLDecoder.decode(path, StandardCharsets.UTF_8);
                if (this.isInvalidPath(decodedPath)) {
                    return true;
                }
                if (this.isInvalidPath(decodedPath = this.processPath(decodedPath))) {
                    return true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    protected boolean isInvalidPath(String path) {
        if (path.contains("WEB-INF") || path.contains("META-INF")) {
            if (logger.isWarnEnabled()) {
                logger.warn(LogFormatUtils.formatValue("Path with \"WEB-INF\" or \"META-INF\": [" + path + "]", -1, true));
            }
            return true;
        }
        if (path.contains(":/")) {
            String relativePath;
            String string = relativePath = path.charAt(0) == '/' ? path.substring(1) : path;
            if (ResourceUtils.isUrl(relativePath) || relativePath.startsWith("url:")) {
                if (logger.isWarnEnabled()) {
                    logger.warn(LogFormatUtils.formatValue("Path represents URL or has \"url:\" prefix: [" + path + "]", -1, true));
                }
                return true;
            }
        }
        if (path.contains("..") && StringUtils.cleanPath(path).contains("../")) {
            if (logger.isWarnEnabled()) {
                logger.warn(LogFormatUtils.formatValue("Path contains \"../\" after call to StringUtils#cleanPath: [" + path + "]", -1, true));
            }
            return true;
        }
        return false;
    }

    @Nullable
    private MediaType getMediaType(Resource resource) {
        List<MediaType> mediaTypes;
        String ext;
        MediaType mediaType = null;
        String filename = resource.getFilename();
        if (!CollectionUtils.isEmpty(this.mediaTypes) && (ext = StringUtils.getFilenameExtension(filename)) != null) {
            mediaType = this.mediaTypes.get(ext.toLowerCase(Locale.ENGLISH));
        }
        if (mediaType == null && !CollectionUtils.isEmpty(mediaTypes = MediaTypeFactory.getMediaTypes(filename))) {
            mediaType = mediaTypes.get(0);
        }
        return mediaType;
    }

    protected void setHeaders(ServerWebExchange exchange2, Resource resource, @Nullable MediaType mediaType) throws IOException {
        HttpHeaders headers = exchange2.getResponse().getHeaders();
        long length = resource.contentLength();
        headers.setContentLength(length);
        if (mediaType != null) {
            headers.setContentType(mediaType);
        }
        if (resource instanceof HttpResource) {
            HttpResource httpResource = (HttpResource)resource;
            exchange2.getResponse().getHeaders().putAll(httpResource.getResponseHeaders());
        }
    }

    public String toString() {
        return "ResourceWebHandler " + this.locationToString(this.getLocations());
    }

    private String locationToString(List<Resource> locations) {
        return locations.toString().replaceAll("class path resource", "classpath").replaceAll("ServletContext resource", "ServletContext");
    }
}

