/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign;

import feign.InvocationHandlerFactory;
import feign.Target;
import feign.Util;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;

public final class ReactiveInvocationHandler
implements InvocationHandler {
    private final Target<?> target;
    private final Map<Method, InvocationHandlerFactory.MethodHandler> dispatch;

    private ReactiveInvocationHandler(Target<?> target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
        this.target = Util.checkNotNull(target, "target must not be null", new Object[0]);
        this.dispatch = Util.checkNotNull(dispatch, "dispatch must not be null", new Object[0]);
        this.defineObjectMethodsHandlers();
    }

    private void defineObjectMethodsHandlers() {
        try {
            this.dispatch.put(Object.class.getMethod("equals", Object.class), args -> {
                InvocationHandler otherHandler = args.length > 0 && args[0] != null ? Proxy.getInvocationHandler(args[0]) : null;
                return this.equals(otherHandler);
            });
            this.dispatch.put(Object.class.getMethod("hashCode", new Class[0]), args -> this.hashCode());
            this.dispatch.put(Object.class.getMethod("toString", new Class[0]), args -> this.toString());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return this.dispatch.get(method).invoke(args);
    }

    public boolean equals(Object other) {
        if (other instanceof ReactiveInvocationHandler) {
            ReactiveInvocationHandler otherHandler = (ReactiveInvocationHandler)other;
            return this.target.equals(otherHandler.target);
        }
        return false;
    }

    public int hashCode() {
        return this.target.hashCode();
    }

    public String toString() {
        return this.target.toString();
    }

    public static final class Factory
    implements InvocationHandlerFactory {
        @Override
        public InvocationHandler create(Target target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
            return new ReactiveInvocationHandler(target, dispatch);
        }
    }
}

