/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.handler;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.util.CollectionUtils;
import org.springframework.web.reactive.handler.AbstractUrlHandlerMapping;

public class SimpleUrlHandlerMapping
extends AbstractUrlHandlerMapping {
    private final Map<String, Object> urlMap = new LinkedHashMap<String, Object>();

    public SimpleUrlHandlerMapping() {
    }

    public SimpleUrlHandlerMapping(Map<String, ?> urlMap) {
        this.setUrlMap(urlMap);
    }

    public SimpleUrlHandlerMapping(Map<String, ?> urlMap, int order) {
        this.setUrlMap(urlMap);
        this.setOrder(order);
    }

    public void setMappings(Properties mappings) {
        CollectionUtils.mergePropertiesIntoMap(mappings, this.urlMap);
    }

    public void setUrlMap(Map<String, ?> urlMap) {
        this.urlMap.putAll(urlMap);
    }

    public Map<String, ?> getUrlMap() {
        return this.urlMap;
    }

    public void initApplicationContext() throws BeansException {
        super.initApplicationContext();
        this.registerHandlers(this.urlMap);
    }

    protected void registerHandlers(Map<String, Object> urlMap) throws BeansException {
        if (urlMap.isEmpty()) {
            this.logger.trace("No patterns in " + this.formatMappingName());
        } else {
            for (Map.Entry<String, Object> entry : urlMap.entrySet()) {
                Object url = entry.getKey();
                Object handler = entry.getValue();
                if (!((String)url).startsWith("/")) {
                    url = "/" + (String)url;
                }
                if (handler instanceof String) {
                    String handlerName = (String)handler;
                    handler = handlerName.trim();
                }
                this.registerHandler((String)url, handler);
            }
            this.logMappings();
        }
    }

    private void logMappings() {
        if (this.mappingsLogger.isDebugEnabled()) {
            this.mappingsLogger.debug(this.formatMappingName() + " " + this.getHandlerMap());
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Patterns " + this.getHandlerMap().keySet() + " in " + this.formatMappingName());
        }
    }
}

