/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.util.List;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.springframework.core.codec.CodecException;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClientException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

abstract class WebClientUtils {
    private static final String VALUE_NONE = "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n";
    public static final Predicate<? super Throwable> WRAP_EXCEPTION_PREDICATE = t -> !(t instanceof WebClientException) && !(t instanceof CodecException);

    WebClientUtils() {
    }

    public static <T> Mono<ResponseEntity<T>> mapToEntity(ClientResponse response, Mono<T> bodyMono) {
        return bodyMono.defaultIfEmpty(VALUE_NONE).map(body2 -> new ResponseEntity<Object>(body2 != VALUE_NONE ? body2 : null, (MultiValueMap<String, String>)response.headers().asHttpHeaders(), response.statusCode()));
    }

    public static <T> Mono<ResponseEntity<List<T>>> mapToEntityList(ClientResponse response, Publisher<T> body2) {
        return Flux.from(body2).collectList().map(list -> new ResponseEntity<List>((List)list, (MultiValueMap<String, String>)response.headers().asHttpHeaders(), response.statusCode()));
    }
}

