/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.util;

import java.io.Serializable;
import org.openjdk.jmh.util.MultisetStatistics;
import org.openjdk.jmh.util.Statistics;

public class SampleBuffer
implements Serializable {
    private static final long serialVersionUID = 6124923853916845327L;
    private static final int PRECISION_BITS = 10;
    private static final int BUCKETS = 54;
    private final int[][] hdr = new int[54][];

    public void half() {
        for (int[] bucket : this.hdr) {
            if (bucket == null) continue;
            for (int j = 0; j < bucket.length; ++j) {
                int nV = bucket[j] / 2;
                if (nV == 0) continue;
                bucket[j] = nV;
            }
        }
    }

    public void add(long sample) {
        int bucket = Math.max(0, 54 - Long.numberOfLeadingZeros(sample));
        int subBucket = (int)(sample >> bucket);
        int[] b = this.hdr[bucket];
        if (b == null) {
            b = new int[1024];
            this.hdr[bucket] = b;
        }
        int n = subBucket;
        b[n] = b[n] + 1;
    }

    public Statistics getStatistics(double multiplier) {
        MultisetStatistics stat = new MultisetStatistics();
        for (int i2 = 0; i2 < this.hdr.length; ++i2) {
            int[] bucket = this.hdr[i2];
            if (bucket == null) continue;
            for (int j = 0; j < bucket.length; ++j) {
                long ns = (long)j << i2;
                stat.addValue(multiplier * (double)ns, bucket[j]);
            }
        }
        return stat;
    }

    public void addAll(SampleBuffer other) {
        for (int i2 = 0; i2 < other.hdr.length; ++i2) {
            int[] otherBucket = other.hdr[i2];
            if (otherBucket == null) continue;
            int[] myBucket = this.hdr[i2];
            if (myBucket == null) {
                myBucket = new int[1024];
                this.hdr[i2] = myBucket;
            }
            for (int j = 0; j < otherBucket.length; ++j) {
                int n = j;
                myBucket[n] = myBucket[n] + otherBucket[j];
            }
        }
    }

    public int count() {
        int count = 0;
        for (int[] bucket : this.hdr) {
            if (bucket == null) continue;
            for (int v : bucket) {
                count += v;
            }
        }
        return count;
    }
}

