/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.client;

import io.reactivex.netty.client.ClientMetricsEvent;
import io.reactivex.netty.client.PoolExhaustedException;
import io.reactivex.netty.client.PoolLimitDeterminationStrategy;
import java.util.concurrent.TimeUnit;

public class CompositePoolLimitDeterminationStrategy
implements PoolLimitDeterminationStrategy {
    private final PoolLimitDeterminationStrategy[] strategies;

    public CompositePoolLimitDeterminationStrategy(PoolLimitDeterminationStrategy ... strategies) {
        if (null == strategies || strategies.length == 0) {
            throw new IllegalArgumentException("Strategies can not be null or empty.");
        }
        for (PoolLimitDeterminationStrategy strategy : strategies) {
            if (null != strategy) continue;
            throw new IllegalArgumentException("No strategy can be null.");
        }
        this.strategies = strategies;
    }

    @Override
    public boolean acquireCreationPermit(long acquireStartTime, TimeUnit timeUnit) {
        for (int i2 = 0; i2 < this.strategies.length; ++i2) {
            PoolLimitDeterminationStrategy strategy = this.strategies[i2];
            if (strategy.acquireCreationPermit(acquireStartTime, timeUnit)) continue;
            PoolExhaustedException throwable = new PoolExhaustedException();
            if (i2 > 0) {
                long now = timeUnit.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                for (int j = i2 - 1; j >= 0; --j) {
                    this.strategies[j].onEvent(ClientMetricsEvent.CONNECT_FAILED, now - acquireStartTime, timeUnit, throwable, null);
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public int getAvailablePermits() {
        int minPermits = Integer.MAX_VALUE;
        for (PoolLimitDeterminationStrategy strategy : this.strategies) {
            int availablePermits = strategy.getAvailablePermits();
            minPermits = Math.min(minPermits, availablePermits);
        }
        return minPermits;
    }

    @Override
    public void onEvent(ClientMetricsEvent<?> event, long duration, TimeUnit timeUnit, Throwable throwable, Object value) {
        for (PoolLimitDeterminationStrategy strategy : this.strategies) {
            strategy.onEvent(event, duration, timeUnit, throwable, value);
        }
    }

    @Override
    public void onCompleted() {
        for (PoolLimitDeterminationStrategy strategy : this.strategies) {
            strategy.onCompleted();
        }
    }

    @Override
    public void onSubscribe() {
        for (PoolLimitDeterminationStrategy strategy : this.strategies) {
            strategy.onCompleted();
        }
    }
}

