/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import reactivefeign.client.ReactiveHttpRequest;
import reactivefeign.client.ReactiveHttpRequestInterceptor;
import reactivefeign.utils.MultiValueMapUtils;
import reactivefeign.utils.Pair;
import reactor.core.publisher.Mono;

public final class ReactiveHttpRequestInterceptors {
    private static final String QUERY_PAIRS_SEPARATOR = "&";
    private static final String QUERY_KEY_VALUE_SEPARATOR = "=";

    private ReactiveHttpRequestInterceptors() {
    }

    public static ReactiveHttpRequestInterceptor addHeader(String header, String value) {
        return ReactiveHttpRequestInterceptors.addHeaders(Collections.singletonList(new Pair<String, String>(header, value)));
    }

    public static ReactiveHttpRequestInterceptor addHeaders(List<Pair<String, String>> headers2) {
        return ReactiveHttpRequestInterceptors.from(request -> {
            headers2.forEach(header -> MultiValueMapUtils.addOrdered(request.headers(), (String)header.left, (String)header.right));
            return request;
        });
    }

    public static ReactiveHttpRequestInterceptor addQuery(String name, String value) {
        return ReactiveHttpRequestInterceptors.addQueries(Collections.singletonList(new Pair<String, String>(name, value)));
    }

    public static ReactiveHttpRequestInterceptor addQueries(List<Pair<String, String>> queries) {
        return ReactiveHttpRequestInterceptors.from(reactiveHttpRequest -> ReactiveHttpRequestInterceptors.reactiveHttpRequestWithQueries(reactiveHttpRequest, queries));
    }

    public static ReactiveHttpRequestInterceptor from(Function<ReactiveHttpRequest, ReactiveHttpRequest> function) {
        return request -> Mono.just((ReactiveHttpRequest)function.apply((ReactiveHttpRequest)request));
    }

    private static ReactiveHttpRequest reactiveHttpRequestWithQueries(ReactiveHttpRequest reactiveHttpRequest, List<Pair<String, String>> queries) {
        URI uri = reactiveHttpRequest.uri();
        Object query = uri.getQuery();
        for (Pair<String, String> queryPair : queries) {
            String keyValuePair = (String)queryPair.left + QUERY_KEY_VALUE_SEPARATOR + (String)queryPair.right;
            if (query == null) {
                query = keyValuePair;
                continue;
            }
            query = (String)query + QUERY_PAIRS_SEPARATOR + keyValuePair;
        }
        try {
            return new ReactiveHttpRequest(reactiveHttpRequest, new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), (String)query, uri.getFragment()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

