/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign;

public abstract class ReactiveOptions {
    private final Boolean useHttp2;
    private final Long connectTimeoutMillis;
    private final Boolean acceptCompressed;
    private final Boolean followRedirects;
    private final ProxySettings proxySettings;

    protected ReactiveOptions(Boolean useHttp2, Long connectTimeoutMillis, Boolean acceptCompressed, Boolean followRedirects, ProxySettings proxySettings) {
        this.useHttp2 = useHttp2;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.acceptCompressed = acceptCompressed;
        this.followRedirects = followRedirects;
        this.proxySettings = proxySettings;
    }

    public Boolean getUseHttp2() {
        return this.useHttp2;
    }

    public Long getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public Boolean isTryUseCompression() {
        return this.acceptCompressed;
    }

    public Boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public ProxySettings getProxySettings() {
        return this.proxySettings;
    }

    public static boolean useHttp2(ReactiveOptions options) {
        return options != null && options.getUseHttp2() != null && options.getUseHttp2() != false;
    }

    public static class ProxySettingsBuilder {
        protected String host;
        protected int port;

        public ProxySettingsBuilder host(String host) {
            this.host = host;
            return this;
        }

        public ProxySettingsBuilder port(int port) {
            this.port = port;
            return this;
        }

        public ProxySettings build() {
            return new ProxySettings(this.host, this.port);
        }
    }

    public static class ProxySettings {
        private final String host;
        private final int port;

        protected ProxySettings(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }
    }

    public static abstract class Builder<B extends Builder<B>> {
        protected Boolean useHttp2;
        protected Long connectTimeoutMillis;
        protected Boolean acceptCompressed;
        protected Boolean followRedirects;
        protected ProxySettings proxySettings;

        public B setUseHttp2(boolean useHttp2) {
            this.useHttp2 = useHttp2;
            return (B)this;
        }

        public B setConnectTimeoutMillis(long connectTimeoutMillis) {
            this.connectTimeoutMillis = connectTimeoutMillis;
            return (B)this;
        }

        public B setAcceptCompressed(boolean acceptCompressed) {
            this.acceptCompressed = acceptCompressed;
            return (B)this;
        }

        public B setFollowRedirects(boolean followRedirects) {
            this.followRedirects = followRedirects;
            return (B)this;
        }

        public B setProxySettings(ProxySettings proxySettings) {
            this.proxySettings = proxySettings;
            return (B)this;
        }

        public abstract ReactiveOptions build();
    }
}

