/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.reactive;

import java.net.HttpCookie;
import java.net.URI;
import java.util.Collection;
import java.util.function.Function;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.reactive.client.ContentChunk;
import org.eclipse.jetty.reactive.client.ReactiveRequest;
import org.eclipse.jetty.util.Callback;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.PooledDataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.reactive.AbstractClientHttpRequest;
import org.springframework.http.client.reactive.JettyHeadersAdapter;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

class JettyClientHttpRequest
extends AbstractClientHttpRequest {
    private final Request jettyRequest;
    private final DataBufferFactory bufferFactory;
    private final ReactiveRequest.Builder builder;

    public JettyClientHttpRequest(Request jettyRequest, DataBufferFactory bufferFactory) {
        this.jettyRequest = jettyRequest;
        this.bufferFactory = bufferFactory;
        this.builder = ReactiveRequest.newBuilder(this.jettyRequest).abortOnCancel(true);
    }

    @Override
    public HttpMethod getMethod() {
        return HttpMethod.valueOf(this.jettyRequest.getMethod());
    }

    @Override
    public URI getURI() {
        return this.jettyRequest.getURI();
    }

    @Override
    public Mono<Void> setComplete() {
        return this.doCommit();
    }

    @Override
    public DataBufferFactory bufferFactory() {
        return this.bufferFactory;
    }

    @Override
    public <T> T getNativeRequest() {
        return (T)this.jettyRequest;
    }

    @Override
    public Mono<Void> writeWith(Publisher<? extends DataBuffer> body2) {
        return Mono.create(sink -> {
            ReactiveRequest.Content content = Flux.from(body2).map(buffer -> this.toContentChunk((DataBuffer)buffer, (MonoSink<Void>)sink)).as(chunks -> ReactiveRequest.Content.fromPublisher(chunks, this.getContentType()));
            this.builder.content(content);
            sink.success();
        }).then(this.doCommit());
    }

    @Override
    public Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> body2) {
        return this.writeWith(Flux.from(body2).flatMap(Function.identity()).doOnDiscard(PooledDataBuffer.class, DataBufferUtils::release));
    }

    private String getContentType() {
        MediaType contentType2 = this.getHeaders().getContentType();
        return contentType2 != null ? contentType2.toString() : "application/octet-stream";
    }

    private ContentChunk toContentChunk(final DataBuffer buffer, final MonoSink<Void> sink) {
        return new ContentChunk(buffer.asByteBuffer(), new Callback(){

            @Override
            public void succeeded() {
                DataBufferUtils.release(buffer);
            }

            @Override
            public void failed(Throwable t) {
                DataBufferUtils.release(buffer);
                sink.error(t);
            }
        });
    }

    @Override
    protected void applyCookies() {
        this.getCookies().values().stream().flatMap(Collection::stream).map(cookie -> new HttpCookie(cookie.getName(), cookie.getValue())).forEach(this.jettyRequest::cookie);
    }

    @Override
    protected void applyHeaders() {
        HttpHeaders headers2 = this.getHeaders();
        headers2.forEach((key, value) -> value.forEach(v -> this.jettyRequest.header((String)key, (String)v)));
        if (!headers2.containsKey("Accept")) {
            this.jettyRequest.header("Accept", "*/*");
        }
    }

    @Override
    protected HttpHeaders initReadOnlyHeaders() {
        return HttpHeaders.readOnlyHttpHeaders(new JettyHeadersAdapter(this.jettyRequest.getHeaders()));
    }

    public ReactiveRequest toReactiveRequest() {
        return this.builder.build();
    }
}

