/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http;

import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;

public class HttpEntity<T> {
    public static final HttpEntity<?> EMPTY = new HttpEntity();
    private final HttpHeaders headers;
    @Nullable
    private final T body;

    protected HttpEntity() {
        this(null, null);
    }

    public HttpEntity(T body2) {
        this(body2, null);
    }

    public HttpEntity(MultiValueMap<String, String> headers2) {
        this(null, headers2);
    }

    public HttpEntity(@Nullable T body2, @Nullable MultiValueMap<String, String> headers2) {
        this.body = body2;
        this.headers = HttpHeaders.readOnlyHttpHeaders((MultiValueMap<String, String>)(headers2 != null ? headers2 : new HttpHeaders()));
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Nullable
    public T getBody() {
        return this.body;
    }

    public boolean hasBody() {
        return this.body != null;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        HttpEntity otherEntity = (HttpEntity)other;
        return ObjectUtils.nullSafeEquals(this.headers, otherEntity.headers) && ObjectUtils.nullSafeEquals(this.body, otherEntity.body);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.headers) * 29 + ObjectUtils.nullSafeHashCode(this.body);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("<");
        if (this.body != null) {
            builder.append(this.body);
            builder.append(',');
        }
        builder.append(this.headers);
        builder.append('>');
        return builder.toString();
    }
}

