/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.client;

import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactivefeign.client.ReactiveErrorMapper;
import reactivefeign.client.ReactiveHttpClient;
import reactivefeign.client.ReactiveHttpRequest;
import reactivefeign.client.ReactiveHttpResponse;
import reactor.core.publisher.Mono;

public interface ReactiveHttpExchangeFilterFunction<P extends Publisher<?>> {
    public Mono<ReactiveHttpResponse<P>> filter(ReactiveHttpRequest var1, ReactiveHttpClient<P> var2);

    default public ReactiveHttpExchangeFilterFunction<P> then(ReactiveHttpExchangeFilterFunction<P> afterFilter) {
        return (request, next) -> this.filter(request, afterRequest -> afterFilter.filter(afterRequest, next));
    }

    default public ReactiveHttpClient<P> filter(ReactiveHttpClient<P> exchangeFunction) {
        return request -> this.filter(request, exchangeFunction);
    }

    public static <P extends Publisher<?>> ReactiveHttpExchangeFilterFunction<P> ofRequestProcessor(Function<ReactiveHttpRequest, Mono<ReactiveHttpRequest>> processor) {
        return (request, next) -> ((Mono)processor.apply(request)).flatMap(next::executeRequest);
    }

    public static <P extends Publisher<?>> ReactiveHttpExchangeFilterFunction<P> ofResponseProcessor(Function<ReactiveHttpResponse<P>, Mono<ReactiveHttpResponse<P>>> processor) {
        return (request, next) -> next.executeRequest(request).flatMap(processor);
    }

    public static <P extends Publisher<?>> ReactiveHttpExchangeFilterFunction<P> ofErrorMapper(ReactiveErrorMapper errorMapper) {
        return (request, next) -> next.executeRequest(request).onErrorMap(throwable -> (Throwable)errorMapper.apply(request, throwable));
    }
}

