/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.util.lines;

class Armor {
    static final String DICT = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";

    Armor() {
    }

    private static void encodeStep(int[] ibuf, int[] obuf) {
        obuf[0] = ibuf[0] & 0x3F;
        obuf[1] = ((ibuf[0] & 0xFF) >> 6) + ((ibuf[1] & 0xF) << 2);
        obuf[2] = ((ibuf[1] & 0xFF) >> 4) + ((ibuf[2] & 3) << 4);
        obuf[3] = (ibuf[2] & 0xFF) >> 2;
        obuf[4] = ibuf[3] & 0x3F;
        obuf[5] = ((ibuf[3] & 0xFF) >> 6) + ((ibuf[4] & 0xF) << 2);
        obuf[6] = ((ibuf[4] & 0xFF) >> 4) + ((ibuf[5] & 3) << 4);
        obuf[7] = (ibuf[5] & 0xFF) >> 2;
    }

    private static void decodeStep(int[] ibuf, int[] obuf) {
        obuf[0] = (ibuf[0] & 0xFF) + ((ibuf[1] & 3) << 6);
        obuf[1] = ((ibuf[1] & 0xFF) >> 2) + ((ibuf[2] & 0xF) << 4);
        obuf[2] = ((ibuf[2] & 0xFF) >> 4) + ((ibuf[3] & 0x3F) << 2);
        obuf[3] = (ibuf[4] & 0xFF) + ((ibuf[5] & 3) << 6);
        obuf[4] = ((ibuf[5] & 0xFF) >> 2) + ((ibuf[6] & 0xF) << 4);
        obuf[5] = ((ibuf[6] & 0xFF) >> 4) + ((ibuf[7] & 0x3F) << 2);
    }

    public static String encode(String src) {
        StringBuilder sb = new StringBuilder();
        char[] chars = src.toCharArray();
        int[] ibuf = new int[6];
        int[] obuf = new int[8];
        for (int c = 0; c < chars.length / 3; ++c) {
            int i2;
            for (i2 = 0; i2 < 3; ++i2) {
                ibuf[i2 * 2 + 0] = chars[c * 3 + i2] & 0xFF;
                ibuf[i2 * 2 + 1] = chars[c * 3 + i2] >> 8 & 0xFF;
            }
            Armor.encodeStep(ibuf, obuf);
            for (i2 = 0; i2 < 8; ++i2) {
                sb.append(DICT.charAt(obuf[i2]));
            }
        }
        int tail = chars.length % 3;
        if (tail != 0) {
            int i3;
            int tailStart = chars.length / 3 * 3;
            char PAD = DICT.charAt(DICT.length() - 1);
            for (i3 = 0; i3 < tail; ++i3) {
                ibuf[i3 * 2 + 0] = chars[tailStart + i3] & 0xFF;
                ibuf[i3 * 2 + 1] = chars[tailStart + i3] >> 8 & 0xFF;
            }
            for (i3 = tail; i3 < 3; ++i3) {
                ibuf[i3 * 2 + 0] = 0;
                ibuf[i3 * 2 + 1] = 0;
            }
            Armor.encodeStep(ibuf, obuf);
            for (i3 = 0; i3 < tail * 3; ++i3) {
                sb.append(DICT.charAt(obuf[i3]));
            }
            for (i3 = tail * 3; i3 < 8; ++i3) {
                sb.append(PAD);
            }
        }
        return sb.toString();
    }

    public static String decode(String encoded) {
        char[] encChars = encoded.toCharArray();
        char[] decChars = new char[encChars.length / 8 * 3];
        if (encChars.length % 8 != 0) {
            throw new IllegalArgumentException("The length should be multiple of 8");
        }
        int PAD_IDX = DICT.length() - 1;
        int[] ibuf = new int[8];
        int[] obuf = new int[6];
        int oLen = 0;
        int cut = 0;
        for (int c = 0; c < encChars.length / 8; ++c) {
            int i2;
            for (i2 = 0; i2 < 8; ++i2) {
                ibuf[i2] = DICT.indexOf(encChars[c * 8 + i2]);
            }
            if (ibuf[3] == PAD_IDX) {
                for (i2 = 3; i2 < 8; ++i2) {
                    ibuf[i2] = 0;
                }
                cut = 2;
            } else if (ibuf[6] == PAD_IDX) {
                for (i2 = 6; i2 < 8; ++i2) {
                    ibuf[i2] = 0;
                }
                cut = 1;
            }
            Armor.decodeStep(ibuf, obuf);
            decChars[oLen++] = (char)(obuf[0] + (obuf[1] << 8));
            decChars[oLen++] = (char)(obuf[2] + (obuf[3] << 8));
            decChars[oLen++] = (char)(obuf[4] + (obuf[5] << 8));
        }
        return new String(decChars, 0, decChars.length - cut);
    }
}

