/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.client;

import feign.MethodMetadata;
import feign.Target;
import feign.Util;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;

public final class ReactiveHttpRequest {
    private final MethodMetadata methodMetadata;
    private final Target<?> target;
    private final URI uri;
    private final Map<String, List<String>> headers;
    private final Publisher<Object> body;

    public ReactiveHttpRequest(MethodMetadata methodMetadata, Target<?> target, URI uri, Map<String, List<String>> headers2, Publisher<Object> body2) {
        this.methodMetadata = Util.checkNotNull(methodMetadata, "method of %s", uri);
        this.target = Util.checkNotNull(target, "target of %s", uri);
        this.uri = Util.checkNotNull(uri, "url", new Object[0]);
        this.headers = Util.checkNotNull(headers2, "headers of %s %s", methodMetadata, uri);
        this.body = body2;
    }

    public ReactiveHttpRequest(ReactiveHttpRequest request, URI uri) {
        this(request.methodMetadata, request.target, uri, request.headers, request.body);
    }

    public ReactiveHttpRequest(ReactiveHttpRequest request, Publisher<Object> body2) {
        this(request.methodMetadata, request.target, request.uri, request.headers, body2);
    }

    public String method() {
        return this.methodMetadata.template().method();
    }

    public URI uri() {
        return this.uri;
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public Publisher<Object> body() {
        return this.body;
    }

    public String methodKey() {
        return this.methodMetadata.configKey();
    }
}

