/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.pipeline.ssl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import javax.net.ssl.SSLException;
import rx.Observable;
import rx.subjects.ReplaySubject;

public class SslCompletionHandler
extends ChannelDuplexHandler {
    private final ReplaySubject<Void> sslCompletionStatus = ReplaySubject.create();

    public SslCompletionHandler(Future<Channel> sslHandshakeFuture) {
        sslHandshakeFuture.addListener((GenericFutureListener<Future<Channel>>)new GenericFutureListener<Future<? super Channel>>(){

            @Override
            public void operationComplete(Future<? super Channel> future) throws Exception {
                if (future.isSuccess()) {
                    SslCompletionHandler.this.sslCompletionStatus.onCompleted();
                } else {
                    SslCompletionHandler.this.sslCompletionStatus.onError(future.cause());
                }
            }
        });
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof SSLException) {
            this.sslCompletionStatus.onError(cause);
        }
        super.exceptionCaught(ctx, cause);
    }

    public Observable<Void> sslCompletionStatus() {
        return this.sslCompletionStatus;
    }
}

