/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.publisher.retry;

import feign.MethodMetadata;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactivefeign.client.ReactiveFeignException;
import reactivefeign.client.ReactiveHttpRequest;
import reactivefeign.publisher.PublisherHttpClient;
import reactivefeign.publisher.retry.OutOfRetriesException;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

public abstract class RetryPublisherHttpClient
implements PublisherHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(RetryPublisherHttpClient.class);
    protected final String feignMethodKey;
    protected final PublisherHttpClient publisherClient;
    private final Retry retry;

    protected RetryPublisherHttpClient(PublisherHttpClient publisherClient, MethodMetadata methodMetadata, Retry retry) {
        this.publisherClient = publisherClient;
        this.feignMethodKey = methodMetadata.configKey();
        this.retry = RetryPublisherHttpClient.wrapWithRetryLog(retry, this.feignMethodKey);
    }

    protected Retry getRetry(ReactiveHttpRequest request) {
        return this.wrapWithOutOfRetriesLog(request);
    }

    private Retry wrapWithOutOfRetriesLog(final ReactiveHttpRequest request) {
        return new Retry(){

            @Override
            public Publisher<?> generateCompanion(Flux<Retry.RetrySignal> retrySignals) {
                return Flux.from(RetryPublisherHttpClient.this.retry.generateCompanion(retrySignals)).onErrorResume(throwable -> Mono.just(new OutOfRetriesWrapper((Throwable)throwable, request))).zipWith(Flux.range(1, Integer.MAX_VALUE), (object, index) -> {
                    if (object instanceof OutOfRetriesWrapper) {
                        OutOfRetriesWrapper wrapper = (OutOfRetriesWrapper)object;
                        if (index == 1) {
                            throw Exceptions.propagate(wrapper.getCause());
                        }
                        logger.debug("[{}]---> USED ALL RETRIES", (Object)RetryPublisherHttpClient.this.feignMethodKey, (Object)wrapper.getCause());
                        throw Exceptions.propagate(new OutOfRetriesException(wrapper.getCause(), request));
                    }
                    return object;
                });
            }
        };
    }

    private static Retry wrapWithRetryLog(final Retry retry, final String feignMethodTag) {
        if (logger.isDebugEnabled()) {
            return new Retry(){

                @Override
                public Publisher<?> generateCompanion(Flux<Retry.RetrySignal> retrySignals) {
                    Flux<Retry.RetrySignal> cache = retrySignals.cache();
                    return cache.zipWith(retry.generateCompanion(cache)).map(tuple -> {
                        Throwable failure = ((Retry.RetrySignal)tuple.getT1()).failure();
                        logger.debug("[{}]---> RETRYING on error", (Object)feignMethodTag, (Object)failure);
                        return tuple.getT2();
                    });
                }
            };
        }
        return retry;
    }

    private static class OutOfRetriesWrapper
    extends ReactiveFeignException {
        public OutOfRetriesWrapper(Throwable cause, ReactiveHttpRequest request) {
            super(cause, request);
        }
    }
}

