/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.rtsp;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.AsciiString;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.rtsp.RtspObjectEncoder;
import io.netty.util.CharsetUtil;

public class RtspRequestEncoder
extends RtspObjectEncoder<HttpRequest> {
    private static final byte[] CRLF = new byte[]{13, 10};

    @Override
    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return msg instanceof FullHttpRequest;
    }

    @Override
    protected void encodeInitialLine(ByteBuf buf, HttpRequest request) throws Exception {
        AsciiString method2 = request.method().name();
        buf.writeBytes(method2.array(), method2.arrayOffset(), method2.length());
        buf.writeByte(32);
        buf.writeBytes(request.uri().getBytes(CharsetUtil.UTF_8));
        buf.writeByte(32);
        AsciiString version = request.protocolVersion().text();
        buf.writeBytes(version.array(), version.arrayOffset(), version.length());
        buf.writeBytes(CRLF);
    }
}

