/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.AsciiString;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpVersion
implements Comparable<HttpVersion> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\S+)/(\\d+)\\.(\\d+)");
    private static final String HTTP_1_0_STRING = "HTTP/1.0";
    private static final String HTTP_1_1_STRING = "HTTP/1.1";
    public static final HttpVersion HTTP_1_0 = new HttpVersion("HTTP", 1, 0, false);
    public static final HttpVersion HTTP_1_1 = new HttpVersion("HTTP", 1, 1, true);
    private final AsciiString protocolName;
    private final int majorVersion;
    private final int minorVersion;
    private final AsciiString text;
    private final String textAsString;
    private final boolean keepAliveDefault;

    public static HttpVersion valueOf(String text) {
        if (text == null) {
            throw new NullPointerException("text");
        }
        if ((text = text.trim()).isEmpty()) {
            throw new IllegalArgumentException("text is empty");
        }
        HttpVersion version = HttpVersion.version0(text);
        if (version == null) {
            version = new HttpVersion(text, true);
        }
        return version;
    }

    private static HttpVersion version0(String text) {
        if (HTTP_1_1_STRING.equals(text)) {
            return HTTP_1_1;
        }
        if (HTTP_1_0_STRING.equals(text)) {
            return HTTP_1_0;
        }
        return null;
    }

    public HttpVersion(String text, boolean keepAliveDefault) {
        if (text == null) {
            throw new NullPointerException("text");
        }
        if ((text = text.trim().toUpperCase()).isEmpty()) {
            throw new IllegalArgumentException("empty text");
        }
        Matcher m = VERSION_PATTERN.matcher(text);
        if (!m.matches()) {
            throw new IllegalArgumentException("invalid version format: " + text);
        }
        this.protocolName = new AsciiString((CharSequence)m.group(1));
        this.majorVersion = Integer.parseInt(m.group(2));
        this.minorVersion = Integer.parseInt(m.group(3));
        this.textAsString = this.protocolName + "/" + this.majorVersion + '.' + this.minorVersion;
        this.text = new AsciiString((CharSequence)this.textAsString);
        this.keepAliveDefault = keepAliveDefault;
    }

    public HttpVersion(String protocolName, int majorVersion, int minorVersion, boolean keepAliveDefault) {
        if (protocolName == null) {
            throw new NullPointerException("protocolName");
        }
        if ((protocolName = protocolName.trim().toUpperCase()).isEmpty()) {
            throw new IllegalArgumentException("empty protocolName");
        }
        for (int i2 = 0; i2 < protocolName.length(); ++i2) {
            if (!Character.isISOControl(protocolName.charAt(i2)) && !Character.isWhitespace(protocolName.charAt(i2))) continue;
            throw new IllegalArgumentException("invalid character in protocolName");
        }
        if (majorVersion < 0) {
            throw new IllegalArgumentException("negative majorVersion");
        }
        if (minorVersion < 0) {
            throw new IllegalArgumentException("negative minorVersion");
        }
        this.protocolName = new AsciiString((CharSequence)protocolName);
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.textAsString = protocolName + '/' + majorVersion + '.' + minorVersion;
        this.text = new AsciiString((CharSequence)this.textAsString);
        this.keepAliveDefault = keepAliveDefault;
    }

    public AsciiString protocolName() {
        return this.protocolName;
    }

    public int majorVersion() {
        return this.majorVersion;
    }

    public int minorVersion() {
        return this.minorVersion;
    }

    public AsciiString text() {
        return this.text;
    }

    public boolean isKeepAliveDefault() {
        return this.keepAliveDefault;
    }

    public String toString() {
        return this.textAsString;
    }

    public int hashCode() {
        return (this.protocolName().hashCode() * 31 + this.majorVersion()) * 31 + this.minorVersion();
    }

    public boolean equals(Object o) {
        if (!(o instanceof HttpVersion)) {
            return false;
        }
        HttpVersion that = (HttpVersion)o;
        return this.minorVersion() == that.minorVersion() && this.majorVersion() == that.majorVersion() && this.protocolName().equals((Object)that.protocolName());
    }

    @Override
    public int compareTo(HttpVersion o) {
        int v = this.protocolName().compareTo((CharSequence)o.protocolName());
        if (v != 0) {
            return v;
        }
        v = this.majorVersion() - o.majorVersion();
        if (v != 0) {
            return v;
        }
        return this.minorVersion() - o.minorVersion();
    }
}

