/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.webclient;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.codec.ClientCodecConfigurer;
import org.springframework.http.codec.multipart.Part;
import org.springframework.http.codec.multipart.PartHttpMessageWriter;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriBuilderFactory;

public class CustomizableWebClientBuilder
implements WebClient.Builder {
    private static final Logger logger = LoggerFactory.getLogger(CustomizableWebClientBuilder.class);
    private final WebClient.Builder builder;
    private String baseUrl;
    private Map<String, ?> defaultUriVariables;
    private UriBuilderFactory uriBuilderFactory;
    private Consumer<HttpHeaders> headersConsumer;
    private Map<String, String[]> headers = new HashMap<String, String[]>();
    private Consumer<MultiValueMap<String, String>> cookiesConsumer;
    private Map<String, String[]> cookies = new HashMap<String, String[]>();
    private Consumer<WebClient.RequestHeadersSpec<?>> defaultRequest;
    private Consumer<List<ExchangeFilterFunction>> filtersConsumer;
    private ExchangeStrategies strategies;
    private ExchangeFunction exchangeFunction;
    private ClientHttpConnector connector;
    private Consumer<WebClient.Builder> builderConsumer;
    private List<ExchangeFilterFunction> filters = new ArrayList<ExchangeFilterFunction>();
    private Consumer<ClientCodecConfigurer> consumer;
    private Consumer<ExchangeStrategies.Builder> exchangeStrategies;
    private static final List<MediaType> MULTIPART_MEDIA_TYPES = Arrays.asList(MediaType.MULTIPART_FORM_DATA, MediaType.MULTIPART_MIXED, MediaType.MULTIPART_RELATED);

    public CustomizableWebClientBuilder(WebClient.Builder builder) {
        this.builder = builder = this.addMultipartCodec(builder);
    }

    public WebClient.Builder addMultipartCodec(WebClient.Builder builder) {
        builder = builder.codecs(clientCodecConfigurer -> clientCodecConfigurer.customCodecs().register(new PartHttpMessageWriter(){

            @Override
            public boolean canWrite(ResolvableType elementType, @Nullable MediaType mediaType) {
                return this.isMediaTypeCompatible(mediaType) && Part.class.isAssignableFrom(elementType.toClass());
            }

            public boolean isMediaTypeCompatible(@Nullable MediaType mediaType) {
                if (mediaType == null) {
                    return true;
                }
                for (MediaType supportedMediaType : MULTIPART_MEDIA_TYPES) {
                    if (!supportedMediaType.isCompatibleWith(mediaType)) continue;
                    return true;
                }
                return false;
            }
        }));
        return builder;
    }

    @Override
    public WebClient.Builder baseUrl(String baseUrl) {
        if (this.baseUrl == null) {
            this.baseUrl = baseUrl;
        } else {
            logger.warn("Will ignore baseUrl parameter as it's already been set");
        }
        return this;
    }

    @Override
    public WebClient.Builder defaultUriVariables(Map<String, ?> defaultUriVariables) {
        if (this.defaultUriVariables == null) {
            this.defaultUriVariables = defaultUriVariables;
        } else {
            logger.warn("Will ignore defaultUriVariables parameter as it's already been set");
        }
        return this;
    }

    @Override
    public WebClient.Builder uriBuilderFactory(UriBuilderFactory uriBuilderFactory) {
        if (this.uriBuilderFactory == null) {
            this.uriBuilderFactory = uriBuilderFactory;
        } else {
            logger.warn("Will ignore uriBuilderFactory parameter as it's already been set");
        }
        return this;
    }

    @Override
    public WebClient.Builder defaultHeader(String header, String ... values) {
        if (this.headers.putIfAbsent(header, values) != null) {
            logger.warn("Will ignore header parameter as it's already been set");
        }
        return this;
    }

    @Override
    public WebClient.Builder defaultHeaders(Consumer<HttpHeaders> headersConsumer) {
        if (this.headersConsumer == null) {
            this.headersConsumer = headersConsumer;
        } else {
            logger.warn("Will ignore headersConsumer parameter as it's already been set");
        }
        return this;
    }

    @Override
    public WebClient.Builder defaultCookie(String cookie, String ... values) {
        if (this.cookies.putIfAbsent(cookie, values) != null) {
            logger.warn("Will ignore cookie parameter as it's already been set");
        }
        return this;
    }

    @Override
    public WebClient.Builder defaultCookies(Consumer<MultiValueMap<String, String>> cookiesConsumer) {
        if (this.cookiesConsumer == null) {
            this.cookiesConsumer = cookiesConsumer;
        } else {
            logger.warn("Will ignore cookiesConsumer parameter as it's already been set");
        }
        return this;
    }

    @Override
    public WebClient.Builder defaultRequest(Consumer<WebClient.RequestHeadersSpec<?>> defaultRequest) {
        if (this.defaultRequest == null) {
            this.defaultRequest = defaultRequest;
        } else {
            logger.warn("Will ignore defaultRequest parameter as it's already been set");
        }
        return this;
    }

    @Override
    public WebClient.Builder filter(ExchangeFilterFunction filter2) {
        this.filters.add(filter2);
        return this;
    }

    @Override
    public WebClient.Builder filters(Consumer<List<ExchangeFilterFunction>> filtersConsumer) {
        if (this.filtersConsumer == null) {
            this.filtersConsumer = filtersConsumer;
        } else {
            logger.warn("Will ignore filtersConsumer parameter as it's already been set");
        }
        return this;
    }

    @Override
    public WebClient.Builder clientConnector(ClientHttpConnector connector) {
        if (this.connector != null) {
            logger.warn("Will override connector parameter as it's already been set");
        }
        this.connector = connector;
        return this;
    }

    @Override
    public WebClient.Builder codecs(Consumer<ClientCodecConfigurer> consumer) {
        if (this.consumer == null) {
            this.consumer = consumer;
        } else {
            logger.warn("Will ignore consumer parameter as it's already been set");
        }
        return this;
    }

    @Override
    public WebClient.Builder exchangeStrategies(ExchangeStrategies strategies) {
        if (this.strategies == null) {
            this.strategies = strategies;
        } else {
            logger.warn("Will ignore strategies parameter as it's already been set");
        }
        return this;
    }

    @Override
    public WebClient.Builder exchangeStrategies(Consumer<ExchangeStrategies.Builder> exchangeStrategies) {
        if (this.exchangeStrategies == null) {
            this.exchangeStrategies = exchangeStrategies;
        } else {
            logger.warn("Will ignore strategies parameter as it's already been set");
        }
        return this;
    }

    @Override
    public WebClient.Builder exchangeFunction(ExchangeFunction exchangeFunction) {
        if (this.exchangeFunction == null) {
            this.exchangeFunction = exchangeFunction;
        } else {
            logger.warn("Will ignore exchangeFunction parameter as it's already been set");
        }
        return this;
    }

    @Override
    public WebClient.Builder clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WebClient.Builder apply(Consumer<WebClient.Builder> builderConsumer) {
        if (this.builderConsumer == null) {
            this.builderConsumer = builderConsumer;
        } else {
            logger.warn("Will ignore builderConsumer parameter as it's already been set");
        }
        return this;
    }

    @Override
    public WebClient build() {
        WebClient.Builder builder = this.builder;
        if (this.baseUrl != null) {
            builder = builder.baseUrl(this.baseUrl);
        }
        if (this.defaultUriVariables != null) {
            builder = builder.defaultUriVariables(this.defaultUriVariables);
        }
        if (this.uriBuilderFactory != null) {
            builder = builder.uriBuilderFactory(this.uriBuilderFactory);
        }
        if (this.headersConsumer != null) {
            builder = builder.defaultHeaders(this.headersConsumer);
        }
        for (Map.Entry<String, String[]> entry : this.headers.entrySet()) {
            builder = builder.defaultHeader(entry.getKey(), entry.getValue());
        }
        if (this.cookiesConsumer != null) {
            builder = builder.defaultCookies(this.cookiesConsumer);
        }
        for (Map.Entry<String, String[]> entry : this.cookies.entrySet()) {
            builder = builder.defaultCookie(entry.getKey(), entry.getValue());
        }
        if (this.defaultRequest != null) {
            builder = builder.defaultRequest(this.defaultRequest);
        }
        if (this.filtersConsumer != null) {
            builder = builder.filters(this.filtersConsumer);
        }
        for (ExchangeFilterFunction filter2 : this.filters) {
            builder = builder.filter(filter2);
        }
        if (this.strategies != null) {
            builder = builder.exchangeStrategies(this.strategies);
        }
        if (this.exchangeFunction != null) {
            builder = builder.exchangeFunction(this.exchangeFunction);
        }
        if (this.connector != null) {
            builder = builder.clientConnector(this.connector);
        }
        if (this.builderConsumer != null) {
            builder = builder.apply(this.builderConsumer);
        }
        if (this.consumer != null) {
            builder = builder.codecs(this.consumer);
        }
        if (this.exchangeStrategies != null) {
            builder = builder.exchangeStrategies(this.exchangeStrategies);
        }
        return builder.build();
    }
}

