/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.profile.ExternalProfiler;
import org.openjdk.jmh.profile.PerfSupport;
import org.openjdk.jmh.profile.ProfilerException;
import org.openjdk.jmh.profile.ProfilerOptionFormatter;
import org.openjdk.jmh.profile.ProfilerUtils;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.Aggregator;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ResultRole;
import org.openjdk.jmh.results.ScalarDerivativeResult;
import org.openjdk.jmh.util.ScoreFormatter;
import org.openjdk.jmh.util.Utils;

public class LinuxPerfProfiler
implements ExternalProfiler {
    private final boolean isDelayed;
    private final int delayMs;
    private final List<String> events;

    public LinuxPerfProfiler(String initLine) throws ProfilerException {
        OptionParser parser = new OptionParser();
        parser.formatHelpWith(new ProfilerOptionFormatter("perf"));
        ArgumentAcceptingOptionSpec<Integer> optDelay = parser.accepts("delay", "Delay collection for a given time, in milliseconds; -1 to detect automatically.").withRequiredArg().ofType(Integer.class).describedAs("ms").defaultsTo(-1, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<String> optEvents = parser.accepts("events", "Events to gather.").withRequiredArg().ofType(String.class).withValuesSeparatedBy(",").describedAs("event");
        OptionSet set = ProfilerUtils.parseInitLine(initLine, parser);
        try {
            this.events = set.valuesOf(optEvents);
            this.delayMs = set.valueOf(optDelay);
        }
        catch (OptionException e) {
            throw new ProfilerException(e.getMessage());
        }
        Collection<String> msgs = Utils.tryWith(PerfSupport.PERF_EXEC, "stat", "--log-fd", "2", "echo", "1");
        if (!msgs.isEmpty()) {
            throw new ProfilerException(msgs.toString());
        }
        Collection<String> delay = Utils.tryWith(PerfSupport.PERF_EXEC, "stat", "--log-fd", "2", "--delay", "1", "echo", "1");
        this.isDelayed = delay.isEmpty();
    }

    @Override
    public Collection<String> addJVMInvokeOptions(BenchmarkParams params) {
        long delay = this.delayMs == -1 ? TimeUnit.NANOSECONDS.toMillis((long)params.getWarmup().getCount() * params.getWarmup().getTime().convertTo(TimeUnit.NANOSECONDS)) + TimeUnit.SECONDS.toMillis(1L) : (long)this.delayMs;
        ArrayList<String> invokeOptions = new ArrayList<String>(Arrays.asList(PerfSupport.PERF_EXEC, "stat", "--log-fd", "2", "--detailed", "--detailed", "--detailed"));
        if (this.isDelayed) {
            invokeOptions.add("--delay");
            invokeOptions.add(String.valueOf(delay));
        }
        if (!this.events.isEmpty()) {
            invokeOptions.add("-e");
            invokeOptions.add(Utils.join(this.events, ","));
        }
        return invokeOptions;
    }

    @Override
    public Collection<String> addJVMOptions(BenchmarkParams params) {
        return Collections.emptyList();
    }

    @Override
    public void beforeTrial(BenchmarkParams params) {
    }

    @Override
    public Collection<? extends Result> afterTrial(BenchmarkResult br, long pid, File stdOut, File stdErr) {
        PerfResult result = this.process(stdOut, stdErr);
        return Collections.singleton(result);
    }

    @Override
    public boolean allowPrintOut() {
        return true;
    }

    @Override
    public boolean allowPrintErr() {
        return false;
    }

    @Override
    public String getDescription() {
        return "Linux perf Statistics";
    }

    /*
     * Exception decompiling
     */
    private PerfResult process(File stdOut, File stdErr) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static class PerfResultAggregator
    implements Aggregator<PerfResult> {
        PerfResultAggregator() {
        }

        @Override
        public PerfResult aggregate(Collection<PerfResult> results) {
            long cycles = 0L;
            long instructions = 0L;
            String output = "";
            for (PerfResult r : results) {
                cycles += r.cycles;
                instructions += r.instructions;
                output = output + r.output;
            }
            return new PerfResult(output, cycles, instructions);
        }
    }

    static class PerfResult
    extends Result<PerfResult> {
        private static final long serialVersionUID = -1262685915873231436L;
        private final String output;
        private final long cycles;
        private final long instructions;

        public PerfResult(String output, long cycles, long instructions) {
            super(ResultRole.SECONDARY, "\u00b7perf", PerfResult.of(Double.NaN), "---", AggregationPolicy.AVG);
            this.output = output;
            this.cycles = cycles;
            this.instructions = instructions;
        }

        @Override
        protected Aggregator<PerfResult> getThreadAggregator() {
            return new PerfResultAggregator();
        }

        @Override
        protected Aggregator<PerfResult> getIterationAggregator() {
            return new PerfResultAggregator();
        }

        @Override
        protected Collection<? extends Result> getDerivativeResults() {
            ArrayList<ScalarDerivativeResult> res = new ArrayList<ScalarDerivativeResult>();
            if (this.cycles != 0L && this.instructions != 0L) {
                res.add(new ScalarDerivativeResult("\u00b7ipc", 1.0 * (double)this.instructions / (double)this.cycles, "insns/clk", AggregationPolicy.AVG));
                res.add(new ScalarDerivativeResult("\u00b7cpi", 1.0 * (double)this.cycles / (double)this.instructions, "clks/insn", AggregationPolicy.AVG));
            }
            return res;
        }

        @Override
        public String toString() {
            if (this.cycles != 0L && this.instructions != 0L) {
                return String.format("%s IPC, %s CPI", ScoreFormatter.format(1.0 * (double)this.instructions / (double)this.cycles), ScoreFormatter.format(1.0 * (double)this.cycles / (double)this.instructions));
            }
            return "N/A";
        }

        @Override
        public String extendedInfo() {
            return "Perf stats:\n--------------------------------------------------\n" + this.output;
        }
    }
}

