/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.metrics;

import io.reactivex.netty.metrics.AbstractMetricsEvent;
import io.reactivex.netty.metrics.MetricEventsListener;
import io.reactivex.netty.server.ServerMetricsEvent;
import java.util.concurrent.TimeUnit;

public abstract class ServerMetricEventsListener<T extends ServerMetricsEvent<?>>
implements MetricEventsListener<T> {
    @Override
    public void onEvent(T event, long duration, TimeUnit timeUnit, Throwable throwable, Object value) {
        switch ((ServerMetricsEvent.EventType)((AbstractMetricsEvent)event).getType()) {
            case NewClientConnected: {
                this.onNewClientConnected();
                break;
            }
            case ConnectionHandlingStart: {
                this.onConnectionHandlingStart(duration, timeUnit);
                break;
            }
            case ConnectionHandlingSuccess: {
                this.onConnectionHandlingSuccess(duration, timeUnit);
                break;
            }
            case ConnectionHandlingFailed: {
                this.onConnectionHandlingFailed(duration, timeUnit, throwable);
                break;
            }
            case ConnectionCloseStart: {
                this.onConnectionCloseStart();
                break;
            }
            case ConnectionCloseSuccess: {
                this.onConnectionCloseSuccess(duration, timeUnit);
                break;
            }
            case ConnectionCloseFailed: {
                this.onConnectionCloseFailed(duration, timeUnit, throwable);
                break;
            }
            case WriteStart: {
                this.onWriteStart();
                break;
            }
            case WriteSuccess: {
                this.onWriteSuccess(duration, timeUnit, ((Number)value).longValue());
                break;
            }
            case WriteFailed: {
                this.onWriteFailed(duration, timeUnit, throwable);
                break;
            }
            case FlushStart: {
                this.onFlushStart();
                break;
            }
            case FlushSuccess: {
                this.onFlushSuccess(duration, timeUnit);
                break;
            }
            case FlushFailed: {
                this.onFlushFailed(duration, timeUnit, throwable);
                break;
            }
            case BytesRead: {
                this.onByteRead(((Number)value).longValue());
            }
        }
    }

    protected void onConnectionHandlingFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
    }

    protected void onConnectionHandlingSuccess(long duration, TimeUnit timeUnit) {
    }

    protected void onConnectionHandlingStart(long duration, TimeUnit timeUnit) {
    }

    protected void onConnectionCloseStart() {
    }

    protected void onConnectionCloseSuccess(long duration, TimeUnit timeUnit) {
    }

    protected void onConnectionCloseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
    }

    protected void onNewClientConnected() {
    }

    protected void onByteRead(long bytesRead) {
    }

    protected void onFlushFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
    }

    protected void onFlushSuccess(long duration, TimeUnit timeUnit) {
    }

    protected void onFlushStart() {
    }

    protected void onWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
    }

    protected void onWriteSuccess(long duration, TimeUnit timeUnit, long bytesWritten) {
    }

    protected void onWriteStart() {
    }

    @Override
    public void onCompleted() {
    }

    @Override
    public void onSubscribe() {
    }
}

